/*
   Sequential search for "aardvark" in one file called "data".

   This version does file I/O using a Scanner wrapped around
   a FileInputStream.
*/

import java.time.Instant;
import java.time.Duration;
import java.util.Date;
import java.text.SimpleDateFormat;
import java.io.FileInputStream;
import java.util.Scanner;

public class SearchSequential_v2_stdin
{
   public static void main(String[] args)
   {
      Scanner scanner = new Scanner(System.in);

      final SimpleDateFormat ft = new SimpleDateFormat("hh:mm:ss");
      System.out.println(ft.format(new Date()) + " Search Sequential ver 2 in stdin");
      Instant start = Instant.now();
      int lineNumber = 0;

      while ( scanner.hasNextLine() ) // this blocks
      {
         ++lineNumber;
         String oneLine = scanner.nextLine();
         for (int i = 0; i < oneLine.length() - 8; ++i)
         {
            if ( 'a' == oneLine.charAt(i)
              && 'a' == oneLine.charAt(i+1)
              && 'r' == oneLine.charAt(i+2)
              && 'd' == oneLine.charAt(i+3)
              && 'v' == oneLine.charAt(i+4)
              && 'a' == oneLine.charAt(i+5)
              && 'r' == oneLine.charAt(i+6)
              && 'k' == oneLine.charAt(i+7) )
            {
               System.out.printf("%s line %,d\n", ft.format(new Date()), lineNumber);
            }
         }
      }
      Instant stop = Instant.now();
      long time = Duration.between(start, stop).toMillis();
      System.out.printf("%s processed %,d lines.\n", ft.format(new Date()), lineNumber);
      System.out.printf("elapsed time: %,dms\n", time);
      scanner.close();
   }
}
