/*
   Sequential search for "aardvark" in one file called "data".

   This version does file I/O using a BufferedReader wrapped around
   a FileReader.
*/

import java.time.Instant;
import java.time.Duration;
import java.util.Date;
import java.text.SimpleDateFormat;
import java.io.IOException;
import java.io.FileReader;
import java.io.BufferedReader;

public class SearchSequential_v3_File
{
   private static final int BUFFERSIZE = 16 * 8192; // changing this doesn't seem to matter

   public static void main(String[] args) throws IOException
   {
      final BufferedReader br = new BufferedReader(new FileReader("data"), BUFFERSIZE);

      final SimpleDateFormat ft = new SimpleDateFormat("hh:mm:ss");
      System.out.println(ft.format(new Date()) + " Search Sequential ver 3 in File");
      Instant start = Instant.now();
      int lineNumber = 0;

      String oneLine = null;
      while ( (oneLine = br.readLine()) != null ) // this blocks
      {
         ++lineNumber;
         for (int i = 0; i < oneLine.length() - 8; ++i)
         {
            if ( 'a' == oneLine.charAt(i)
              && 'a' == oneLine.charAt(i+1)
              && 'r' == oneLine.charAt(i+2)
              && 'd' == oneLine.charAt(i+3)
              && 'v' == oneLine.charAt(i+4)
              && 'a' == oneLine.charAt(i+5)
              && 'r' == oneLine.charAt(i+6)
              && 'k' == oneLine.charAt(i+7) )
            {
               System.out.printf("%s line %,d\n", ft.format(new Date()), lineNumber);
            }
         }
      }
      Instant stop = Instant.now();
      long time = Duration.between(start, stop).toMillis();
      System.out.printf("%s processed %,d lines.\n", ft.format(new Date()), lineNumber);
      System.out.printf("elapsed time: %,dms\n", time);
      br.close();
   }
}
