/*
   Sequential search for "aardvark" in the stdin stream.

   This version does its own buffering of the System.in stream
   (but notice that System.in is itself a buffered stream).

   This version is incorrect in that it will miss any "aardvark"
   matches that span across two input buffers (which is not very
   likely to happen).
*/

import java.time.Instant;
import java.time.Duration;
import java.util.Date;
import java.text.SimpleDateFormat;
import java.io.IOException;

public class SearchSequential_v4_stdin
{
   private static final int BUFFERSIZE = 16 * 8192; // changing this doesn't seem to matter

   public static void main(String[] args) throws IOException
   {
      byte[] c = new byte[BUFFERSIZE];
      int n;

      final SimpleDateFormat ft = new SimpleDateFormat("hh:mm:ss");
      System.out.println(ft.format(new Date()) + " Search Sequential ver 4 in stdin");
      Instant start = Instant.now();
      int lineNumber = 1;

      while ( (n = System.in.read(c)) != -1 )
      {
         for (int i = 0; i < n; ++i)
         {
            if ( '\n' == c[i] )
            {
               ++lineNumber;
            }
            else if ( i < n - 8
                   && 'a' == c[i]
                   && 'a' == c[i+1]
                   && 'r' == c[i+2]
                   && 'd' == c[i+3]
                   && 'v' == c[i+4]
                   && 'a' == c[i+5]
                   && 'r' == c[i+6]
                   && 'k' == c[i+7] )
            {
               System.out.printf("%s line %,d\n", ft.format(new Date()), lineNumber);
            }
         }
      }
      Instant stop = Instant.now();
      long time = Duration.between(start, stop).toMillis();
      System.out.printf("%s processed %,d lines.\n", ft.format(new Date()), lineNumber);
      System.out.printf("elapsed time: %,dms\n", time);
   }
}
