/**
   Compare this with 3-thread-vs-function.c
*/
public class Thread_vs_function_3_ver3
{
   public static void main(String[] args)
   {
      // Use an anonymous inner class that implements Runnable.
      Thread t1 = new Thread(
         new Runnable(){
            public void run() // implement Runnable interface
            {
               try
               {
                  System.err.print("hello ");
                  Thread.sleep(1000);
                  System.err.println("from thread " + Thread.currentThread().getId() + "!\n");
               }
               catch(InterruptedException e){e.getMessage();}
            }});

      // Use an anonymous inner class that implements Runnable
      Thread t2 = new Thread(
         new Runnable(){
            public void run() // implement Runnable interface
            {
               try
               {
                  System.err.print("HELLO ");
                  Thread.sleep(1000);
                  System.err.println("FROM THREAD " + Thread.currentThread().getId() + "!\n");
               }
               catch(InterruptedException e){e.getMessage();}
            }});

      t1.start(); // create the thread
      t2.run();   // call the function

      try
      {
         t1.join();
      }
      catch(InterruptedException e){e.getMessage();}

      System.err.println("All done (thread id " + Thread.currentThread().getId() + ").");
      return;
   }
}
