/**
   Compare this with 3-thread-vs-function.c
*/
public class Thread_vs_function_3_ver4
{
   public static void main(String[] args)
   {
      // Use an anonymous inner class that extends Thread.
      Thread t1 = new Thread(){
            @Override
            public void run() // override run() from Thread class
            {
               try
               {
                  System.err.print("hello ");
                  Thread.sleep(1000);
                  System.err.println("from thread " + this.getId() + "!\n");
               }
               catch(InterruptedException e){e.getMessage();}
            }};

      // Use an anonymous inner class that extends Thread.
      Thread t2 = new Thread(){
            @Override
            public void run() // override run() from Thread class
            {
               try
               {
                  System.err.print("HELLO ");
                  Thread.sleep(1000);
                  System.err.println("FROM THREAD " + this.getId() + "!\n");
               }
               catch(InterruptedException e){e.getMessage();}
            }};

      t1.start(); // create the thread
      t2.run();   // call the function

      try
      {
         t1.join();
      }
      catch (InterruptedException e){e.getMessage();}

      System.err.println("All done (thread id " + Thread.currentThread().getId() + ").");
      return;
   }
}
