/**
   Compare this with 4-thread-vs-function-w-args.c
*/
public class Thread_vs_function_4_with_args_ver1
{
   public static void main(String[] args)
   {
      Function f1 = new Function();
      Function f2 = new Function();
      f1.x = 10;  // give each thread "input" values
      f1.y = 20;
      f2.x = 30;
      f2.y = 40;

      Thread t1 = new Thread( f1 );
      Thread t2 = new Thread( f2 );

      t1.start();
      t2.start();

      try
      {
         t1.join();
         t2.join();
      }
      catch(InterruptedException e){e.getMessage();}

      System.out.println(f1.x); // get each thread's "output" value
      System.out.println(f2.x);

      System.err.println("All done.");
      return;
   }
}


class Function implements Runnable
{
   public int x = 0;  // create "input" parameters for a thread
   public int y = 0;

   @Override
   public void run()
   {
      try
      {
         System.err.print("hello ");
         Thread.sleep(1000);
         System.out.println("x = " + x +", y = "+ y);
         System.err.println("from thread " + Thread.currentThread().getId() + "!\n");
         x = x + y;  // create an "ouput" value for a thread
      }
      catch(InterruptedException e){e.getMessage();}
   }
}
