/**
   Compare this with 4-thread-vs-function-w-args.c
*/
public class Thread_vs_function_4_with_args_ver4
{
   public static int z1 = 0; // create an "ouput" parameter for each thread
   public static int z2 = 0;

   public static void main(String[] args)
   {
      // Use an anonymous inner class that implements Runnable.
      final int x1 = 10; // create "input" values for the thread
      final int y1 = 20;
      Thread t1 = new Thread(){
            @Override
            public void run()
            {
               try
               {
                  System.err.print("hello ");
                  Thread.sleep(1000);
                  System.out.println("x1 = " + x1 +", y1 = "+ y1);
                  System.err.println("from thread " + this.getId() + "!\n");
                  z1 = x1 + y1; // create an "ouput" value for this thread
               }
               catch(InterruptedException e){e.getMessage();}
            }};

      // Use an anonymous inner class that implements Runnable
      final int x2 = 30; // create "input" values for the thread
      final int y2 = 40;
      Thread t2 = new Thread(){
            @Override
            public void run()
            {
               try
               {
                  System.err.print("HELLO ");
                  Thread.sleep(1000);
                  System.out.println("x2 = " + x2 +", y2 = "+ y2);
                  System.err.println("FROM THREAD " + this.getId() + "!\n");
                  z2 = x2 + y2; // create an "ouput" value for this thread
               }
               catch(InterruptedException e){e.getMessage();}
            }};

      t1.start();
      t2.start();

      try
      {
         t1.join();
         t2.join();
      }
      catch(InterruptedException e){e.getMessage();}

      System.out.println( z1 ); // get each thread's "output" value
      System.out.println( z2 );

      System.err.println("All done.");
      return;
   }
}
