/**
   Compare this with 6-two-threads-in-one-function.c
*/
public class Thread_vs_function_6_ver1
{
   private static final int N = 2; // number of threads (try changing this value)

   public static void main(String[] args)
   {
      Runnable[] runnable = new Runnable[N];
      Thread[]   thread   = new Thread[N];

      // create multiple threads from a single thread function
      for (char i = 0, c = 'a'; i < N; ++i, ++c)
      {
         runnable[i] = new Function(c);
           thread[i] = new Thread(runnable[i]);
           thread[i].start();
      }

      try
      {
         for (int i = 0; i < N; ++i)
         {
            thread[i].join();
         }
      }
      catch (InterruptedException e){e.getMessage();}

      System.err.println("All done (thread id " + Thread.currentThread().getId() + ").");
      return;
   }
}


class Function implements Runnable
{
   private final char c; // thread parameter

   public Function(char c)
   {
      this.c = c;
   }

   /**
      This thread function can be used to create an
      arbitrary number of "identical" threads.
   */
   @Override
   public void run()
   {
      while(true) // loop forever
      {
         System.err.print(c);
      }
   }
}
