/**
   We can mix up the two patterns for creating a thread
   and give a Thread object two nontrivial run() methods!
*/
public class Threads_11_experiment_1
{
   public static void main(String[] args)
   {
      Thread t1 = new Thread1(); // Use our explicit default constructor.

      t1.start(); // Which run() method gets called?

      try
      {
         t1.join();
      }
      catch (InterruptedException e){e.getMessage();}

      System.err.println("All done (thread id " + Thread.currentThread().getId() + ").");
      return;
   }
}


class Thread1 extends Thread
{
   // Explicitly give this class a default constructor.
   public Thread1()
   {
      // Give this object a non-null Runnable reference.
      super( new Function() );
   }

   @Override
   public void run() // override run() in Thread
   {
      super.run(); // force the running of the Runnable run() method
      try
      {
         System.err.print("hello ");
         Thread.sleep(1000);
         System.err.println("from this thread function! (in thread "
                            + this.getId() + ")\n");
      }
      catch (InterruptedException e){e.getMessage();}
   }
}


class Function implements Runnable
{
   @Override
   public void run()
   {
      try
      {
         System.err.print("HELLO ");
         Thread.sleep(1000);
         System.err.println("FROM THE OTHER THREAD FUNTION! (in thread "
                            + Thread.currentThread().getId() + ")\n");
      }
      catch (InterruptedException e){e.getMessage();}
   }
}
