/**
   Compare this with 7-orphanThread.c

   This program starts up one thread that repeatedly
   prints a single character to standard output. Then
   the main thread exits, leaving just the second
   thread running forever (by itself).

   In some threading frameworks, if the main thread
   exits, then all the other threads in the process
   are also stoped.
*/
public class Threads_7_Orphan
{
   public static void main(String[] args)
   {
      System.out.println("Starting child thread.");
      // create thread
      Function f = new Function();
      Thread t = new Thread( f );
      t.start();

      // let the main thread sleep for a while before it exits
      try{Thread.sleep(3000);}catch(InterruptedException e){}

      System.out.println("Stopping main thread.");
      //System.exit(0); // exit the program (Java doesn't have a "thread exit" function)
      //return;         // exit the main thread
   }                    // exit the main thread (since main() is a void method)
}


class Function implements Runnable
{
   @Override
   public void run()
   {
      while(true)
      {
         System.out.print("a");
      }
   }
}
