/*

*/

import java.util.Scanner;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

/**
   Notice that displaying a message box blocks the application
   until the user clicks the "OK" button in the message box.
   What if we want the message box to appear but for it not
   to block the whole program?
*/
public class Threads_9a_MessageBox_nonthreaded
{
   public static void main(String[] args)
   {
      Scanner in = new Scanner(System.in);
      MessageBox mb = new MessageBox();

      System.out.print("Please enter a number (0 to quit): ");
      int number = in.nextInt();
      while(0 != number)
      {
         // call the function to display the message box
         mb.setNumber(number);
         mb.run();
         System.out.print("Please enter a number (0 to quit): ");
         number = in.nextInt();
      }
      System.exit(0); // try commenting this out
   }
}

class MessageBox implements Runnable
{
   private int number = 0;

   public void setNumber(int number)
   {
      this.number = number;
   }

   @Override
   public void run()
   {
      JOptionPane.showMessageDialog(
                    new JFrame(),
                    "Your number is: " + number,
                    "Here is what you entered",
                    JOptionPane.INFORMATION_MESSAGE);
   }
}
