/*

*/

import java.util.Scanner;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

/**
   This version uses a thread to display the message box. Each display
   thread blocks until the user clicks the "OK" button in its message box.
   But the main thread of the application does not block, so the program's
   user can keep on entering numbers, even while a message box is displayed.
*/
public class Threads_9b_MessageBox_threaded
{
   public static void main(String[] args)
   {
      Scanner in = new Scanner(System.in);
      MessageBox mb = new MessageBox();

      System.out.print("Please enter a number (0 to quit): ");
      int number = in.nextInt();
      while(0 != number)
      {
         // create a thread to display the message box
         mb.setNumber(number);
         new Thread(mb).start();
         System.out.print("Please enter a number (0 to quit): ");
         number = in.nextInt();
      }
      System.exit(0); // try commenting this out
   }
}

class MessageBox implements Runnable
{
   private int number = 0;

   public void setNumber(int number)
   {
      this.number = number;
   }

   public void run()
   {
      JOptionPane.showMessageDialog(
                    new JFrame(),
                    "Your number is: " + number,
                    "Here is what you entered",
                    JOptionPane.INFORMATION_MESSAGE);
   }
}
