#include <stdio.h>
#include "RenderOpenGL.h"

extern bool bilerp_flag;   /* defined in mainMaze.cpp */


void renderSceneOpenGL(Scene *s)
{
   TriangleListNode *ptr;

   /* now clear all the stuff */
   glClearColor(100/(float)255, 0, 0, 0);
   glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
   glEnable(GL_DEPTH_TEST);

   /* render each Triangle from the
      list  of Triangle objects */
   for (ptr = s->head_ptr; ptr;)
   {
      renderTriangleOpenGL(ptr->t);
      ptr = ptr->next;
   }

   glDisable(GL_DEPTH_TEST);

   checkErrorsOpenGL("Errors in rendering scene!");

   return;
}//renderSceneOpenGL()


void renderTriangleOpenGL(Triangle *t)
{
   if (t->tex)
   {
      glBindTexture(GL_TEXTURE_2D, t->tex->tex);
      glEnable(GL_TEXTURE_2D);
   }

   /* now draw the triangle */
   glBegin(GL_TRIANGLES);
      if (t->tex) glTexCoord2f(t->v[0].s, t->v[0].t);
      glColor3f ( t->v[0].r, t->v[0].g, t->v[0].b );
      glVertex3f( t->v[0].x, t->v[0].y, t->v[0].z );

      if (t->tex) glTexCoord2f(t->v[1].s, t->v[1].t);
      glColor3f ( t->v[1].r, t->v[1].g, t->v[1].b );
      glVertex3f( t->v[1].x, t->v[1].y, t->v[1].z );

      if (t->tex) glTexCoord2f(t->v[2].s, t->v[2].t);
      glColor3f ( t->v[2].r, t->v[2].g, t->v[2].b );
      glVertex3f( t->v[2].x, t->v[2].y, t->v[2].z );
   glEnd();

   if (t->tex)
   {
      glDisable(GL_TEXTURE_2D);
   }

   checkErrorsOpenGL("Errors in rendering triangle!");

   return;
}//renderTriangleOpenGL()


void initializeTexturesOpenGL(Scene *s)
{
   int i;

   for (i = 0; i < s->textureCount; i++)
   {
      glGenTextures(1, &(s->textures[i]->tex));
      glBindTexture(GL_TEXTURE_2D, s->textures[i]->tex);
      glTexEnvf( GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_REPLACE );
      glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_NEAREST);

      if (bilerp_flag)
      {
         glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
      }
      else
      {
         glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_NEAREST);
      }

      glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT);
      glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT);

      glTexImage2D( GL_TEXTURE_2D, 0, GL_RGB, s->textures[i]->width,
                                              s->textures[i]->height,
                                              0, GL_RGB, GL_UNSIGNED_BYTE,
                                              s->textures[i]->data );
   }

   checkErrorsOpenGL("Errors in initializing textures!");

   return;
}//initializeTexturesOpenGL()


void switchTextureFilteringOpenGL(Scene *s)
{
   int i;
   for (i = 0; i < s->textureCount; i++)
   {
      glBindTexture(GL_TEXTURE_2D, s->textures[i]->tex);
      if (bilerp_flag)
      {
         glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
      }
      else
      {
         glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_NEAREST);
      }
   }

   checkErrorsOpenGL("Errors in switching texture filter!");

   return;
}//switchTextureFilteringOpenGL()


void checkErrorsOpenGL(const char *prefix)
{
   GLenum error;
   if ((error = glGetError()) != GL_NO_ERROR)
   {
      fprintf(stderr,"%s: gl error: %s\n",prefix, gluErrorString(error));
      exit(-1);
   }
   return;
}//checkErrorsOpenGL()
