#include <stdio.h>
#include "Constants.h"
#include "SoftwareRenderer.h"
#include "MazeParser.h"
#include "GLUTCallbacks.h"
#include "GLUTMouseCallbacks.h"


/*** Define global variables ***/
Scene *scene; /* Pointer to the Scene object that we will build and then render. */

int global_w = window_width;  /* Viewport width */
int global_h = window_height; /* Viewport height */
bool opengl_test = false;     /* Determines OpenGL or software rendering mode */
bool bilerp_flag = false;     /* Determines which rendering mode to use for textures. */

/* store the eye's position and parameters */
double eye_pos[3]; /* the position of the eye */
double eye_fov;    /* field of view of the eye */
double eye_theta;  /* the theta angle of the eye (the longitude).
                      it is positive in a counterclockwise direction when looking down -z */
double eye_phi;    /* the phi angle of the eye (the latitude).
                      i define 0 as the north pole. */



int main(int argc, char **argv)
{
   if (argc != 2)
   {
      fprintf(stderr,"Usage: MazeViewer <file>\n");
      fprintf(stderr,"argc: %d\n", argc);
      return -1;
   }

   /* Initialize GLUT */
   glutInit(&argc, argv);
   glutInitDisplayMode( GLUT_DOUBLE | GLUT_RGBA | GLUT_DEPTH );
   glutInitWindowSize(window_width, window_height);
   glutCreateWindow("window_name");
   glutInitWindowPosition(100,50);

   /* Set all the GLUT callback functions */
   glutDisplayFunc(display);      /* in GLUTCallbacks.cpp */
   glutKeyboardFunc(keyboard);    /* in GLUTCallbacks.cpp */
   glutIdleFunc(redisplay);       /* in GLUTCallbacks.cpp */
   //glutIdleFunc(NULL);
   glutReshapeFunc(reshape);      /* in GLUTCallbacks.cpp */
   glutEntryFunc(mouseEntry);     /* in GLUTMouseCallbacks.cpp */
   glutMotionFunc(mouseMotion);   /* in GLUTMouseCallbacks.cpp */
   glutPassiveMotionFunc(mouseMotion);


   /* set the eye's location */
   eye_pos[0] = 0.0;
   eye_pos[1] = 0.0;
   eye_pos[2] = 5.0;

   /* initialize the eye's parameters */
   eye_theta = 180.0;
   eye_phi = 90.0;
   eye_fov = 45.0;
   computeUpSightAndRightVectors(); /* in GLUTMouseCallbacks.cpp */


   /* Create the Scene object that we shall render. */
   MazeParser mp;
   scene = mp.loadScene(argv[1]);

   initializeTexturesOpenGL(scene); /* in RenderOpenGL.cpp */

   glutMainLoop();                  /* Enter GLUT's main loop */

   return 1;
}
