#ifndef FRAMEBUFFER_H
#define FRAMEBUFFER_H

#include "Scene.h"
#include "Triangle.h"

class FrameBuffer
{
   private:
      void renderTriangle(Triangle *t);
   public:
      int width;
      int height;
      unsigned char *pixel_buffer; /* contains the pixel color data for a rendered frame */

      // viewport data
      int vp_ul_x;
      int vp_ul_y;
      int vp_lr_x;
      int vp_lr_y;

      FrameBuffer(int _w, int _h);

      ~FrameBuffer();

      void setViewport(int _vp_ul_x, int _vp_ul_y, int _vp_lr_x, int _vp_lr_y);


      /* render a Scene or a Triangle into this FrameBuffer */
      void renderScene2Viewport(Scene *s);

      void dumpVP2File(char *filename);
      void dumpFB2File(char *filename);
      void dumpPixels2File(int ul_x, int ul_y, int lr_x, int lr_y, char *filename);
};

#endif /* FRAMEBUFFER_H */
