#include <stdlib.h>
#include "Scene.h"


Scene::Scene()
{
   textureCount = 0;
   head_ptr = NULL;
   tail_ptr = NULL;
}


Scene::~Scene()
{
   destroyList();
}


void Scene::addTexture( Texture *tex)
{
   textures[textureCount++] = tex;
   return;
}


void Scene::addTriangle( Triangle *tri )
{
   if (head_ptr == NULL) /* insert the first Triangle into an empty list */
   {
      head_ptr = new TriangleListNode();
      head_ptr->t = tri;
      tail_ptr = head_ptr;
   }
   else
   {
      tail_ptr->next = new TriangleListNode();
      tail_ptr = tail_ptr->next;
      tail_ptr->t = tri;
   }
   return;
}


void Scene::setProjMatrix2Identity()
{
   projection = Matrix(1,1,1);
}


void Scene::setViewMatrix2Identity()
{
   view = Matrix(1,1,1);
}


void Scene::setModelMatrix2Identity()
{
   model = Matrix(1,1,1);
}


void Scene::multProjMatrix(Matrix m)
{
   projection = projection.times(m);
}


void Scene::multViewMatrix(Matrix m)
{
   projection = view.times(m);
}


void Scene::multModelMatrix(Matrix m)
{
   projection = model.times(m);
}


void Scene::setPerspectiveProj(double eye_fov, double aspect_ratio, double near, double far)
{

   return;
}


void Scene::destroyList()
{
   TriangleListNode *ptr;

   while (head_ptr)
   {
      ptr = head_ptr->next;

      free(head_ptr->t); /* free the Triangle object */
      free(head_ptr);    /* free the TriangleListNode object */

      head_ptr = ptr;
   }
   head_ptr = NULL;
   tail_ptr = NULL;
   return;
}
