#ifndef SCENE_H
#define SCENE_H

#include "TriangleListNode.h"
#include "Triangle.h"
#include "Texture.h"
#include "Matrix.h"
#include "Light.h"

class Scene
{
   private:
      void destroyList();

   public:
      /* the scene class is basically a linked list of triangles */
      TriangleListNode *head_ptr;
      TriangleListNode *tail_ptr;
      /* with an array of pointers to Texture objects */
      Texture * textures[256];
      int textureCount;
      Matrix projection;
      Matrix view;
      Matrix model;
      Light light;  /* data structure that describes a light */

      Scene();

      ~Scene();

      void addTriangle( Triangle *tri );

      void addTexture( Texture *tex );

      void setProjMatrix2Identity();
      void setViewMatrix2Identity();
      void setModelMatrix2Identity();

      void multProjMatrix(Matrix m);
      void multViewMatrix(Matrix m);
      void multModelMatrix(Matrix m);

      void setPerspectiveProj(double eye_fov, double aspect_ratio, double near, double far);
};

#endif /* SCENE_H */
