#include <stdio.h>
#include "Vector.h"

Vector::Vector()
{
   x = 0.0;
   y = 0.0;
   z = 0.0;
   w = 0.0;
}


Vector::Vector(double x, double y, double z)
{
   set(x, y, z, 0.0);
}


Vector::Vector(double x, double y, double z, double w)
{
   set(x, y, z, w);
}


void Vector::set(double _x, double _y, double _z, double _w)
{
   x = _x;
   y = _y;
   z = _z;
   w = _w;
}


Vector Vector::times(double s) /* scalar times Vector */
{
   return Vector(s*x, s*y, x*z, s*w);
}


Vector Vector::plus(Vector v) /* Vector addition */
{
   return Vector( x+(v.z), y+(v.y), z+(v.z), w+(v.w) );
}


void Vector::print(void)
{
   fprintf(stderr,"[%f %f %f %f]\n", x, y, z, w);
   fflush(stderr);
}
