#include <stdio.h>
#include <stdlib.h>
#include "Vertex.h"

Vertex::Vertex()
{
   set(0.0, 0.0, 0.0, 1.0);

   setColor(0.0, 0.0, 0.0, 0.0);

   s = 0.0;
   t = 0.0;

   n = Vector();
}

Vertex::Vertex(double x, double y, double z)
{
   set(x, y, z, 1.0);

   setColor(0.0, 0.0, 0.0, 0.0);

   s = 0.0;
   t = 0.0;

   n = Vector();
}

Vertex::Vertex(double x, double y, double z, double w)
{
   set(x, y, z, w);

   setColor(0.0, 0.0, 0.0, 0.0);

   s = 0.0;
   t = 0.0;

   n = Vector();
}

void Vertex::set(double x, double y, double z)
{
   set(x, y, z, 1.0);
}

void Vertex::set(double _x, double _y, double _z, double _w)
{
   x = _x;
   y = _y;
   z = _z;
   w = _w;
}

/* sets the color of this vertex to (r,g,b) */
void Vertex::setColor(double _r, double _g, double _b)
{
   if ( (_r < 0) || (_r > 1.0)
     || (_g < 0) || (_g > 1.0)
     || (_b < 0) || (_b > 1.0) )
   {
      fprintf(stderr,"ERROR! Invalid color for vertex\n");
      fflush(stderr);
      exit(-1);
   }

   r = _r;
   g = _g;
   b = _b;
   a = 0.0;
   return;
}

void Vertex::setColor(int _r, int _g, int _b)
{
   if ( (_r < 0) || (_r > 255)
     || (_g < 0) || (_g > 255)
     || (_b < 0) || (_b > 255) )
   {
      fprintf(stderr,"ERROR! Invalid color for vertex\n");
      fflush(stderr);
      exit(-1);
   }

   r = ((float)_r/(float)255);
   g = ((float)_g/(float)255);
   b = ((float)_b/(float)255);
   a = 0.0;
   return;
}

void Vertex::setColor(int _r, int _g, int _b, int _a)
{
   setColor(_r, _g, _b);
   a = ((float)_a/(float)255);
   return;
}

/* sets the texture coordinate of this vertex to (s, t) */
void Vertex::setCoords(double _s, double _t)
{
   s = _s;
   t = _t;
   return;
}

void Vertex::setNormal(Vector* _n)
{
   n = *(_n);
   return;
}

void Vertex::print(void)
{
   fprintf(stderr,"[%f %f %f %f]\n", x, y, z, w);
   fflush(stderr);
   return;
}
