/*
   x world x-coordinate of the "origin" for the triangle
   y world y-coordinate of the "origin" for the triangle
   z world z-coordinate of the "origin" for the triangle
   h side length of the triangle
*/
#include <stdio.h>
#include "SceneLib.h"

void triangle(double x, double y, double z, double h, Material* mtrl, Scene *scene)
{
   Vertex v1 = Vertex(  h + x, 0.0 + y, 0.0 + z);
   Vertex v2 = Vertex(0.0 + x,   h + y, 0.0 + z);
   Vertex v3 = Vertex(0.0 + x, 0.0 + y,   h + z);

   v1.setColor(1.0, 0.0, 0.0);
   v2.setColor(0.0, 1.0, 0.0);
   v3.setColor(0.0, 0.0, 1.0);
   Triangle *t = new Triangle(&v1, &v2, &v3);
   t->mtrl = mtrl;
   scene->addTriangle( t );

   return;
}
