#ifndef FRAMEBUFFER_H
#define FRAMEBUFFER_H

class FrameBuffer
{
   private:
   public:
      int width;  /* the framebuffer's width */
      int height; /* the framebuffer's height */
      unsigned char *pixel_buffer; /* contains the pixel color data for a rendered frame */

      /* coordinates of the viewport within the framebuffer */
      int vp_ul_x; /* upper left hand corner */
      int vp_ul_y;
      int vp_lr_x; /* lower right hand corner */
      int vp_lr_y;

      FrameBuffer(int _w, int _h);

      ~FrameBuffer();

      void setViewport(int _vp_ul_x, int _vp_ul_y, int _vp_lr_x, int _vp_lr_y);

      void getPixel(int i, int j, unsigned char **c); /* get pixel from within the vewport */
      void setPixel(int i, int j, unsigned char *c);  /* set pixel within the vewport */

      void dumpVP2File(char *filename); /* write the viewport to a file */
      void dumpFB2File(char *filename); /* write the framebuffer to a file */
      void dumpPixels2File(int ul_x, int ul_y, int lr_x, int lr_y, char *filename);
};

#endif /* FRAMEBUFFER_H */
