#include <stdio.h>
#include <math.h>
#include "SceneLib.h"

void doSmoothLighting(Scene *scene);
void doFlatLighting(Scene *scene);

void P4_Lighting(Scene* scene)
{
   // Walk the list of Triangle objects.
   // For each Vertex in each Triangle object,
   // use the Scene's light data, the Triangle's
   // material properties, and the Vertex's normal
   // vector to compute color information for that
   // vertex.

   if (scene->doLighting && scene->light)
   {
      if (scene->doSmoothLighting)
      {
         doSmoothLighting(scene);
      }
      else if (scene->doOpenglFlatLighting != 0)
      {
         doSmoothLighting(scene);
      }
      else
      {
         doFlatLighting(scene);
      }
   }
   return;
}

void doSmoothLighting(Scene *scene)
{
   // Compute the transformation matrix that transforms normal
   // vectors from model coordinates into view coordinates.
   // Get the 3-by-3 part of the model matrix that we need.
   double m11 = scene->model.v1.x, m12 = scene->model.v2.x, m13 = scene->model.v3.x,
          m21 = scene->model.v1.y, m22 = scene->model.v2.y, m23 = scene->model.v3.y,
          m31 = scene->model.v1.z, m32 = scene->model.v2.z, m33 = scene->model.v3.z;
   // Get the 3-by-3 part of the view matrix that we need.
   double v11 = scene->view.v1.x, v12 = scene->view.v2.x, v13 = scene->view.v3.x,
          v21 = scene->view.v1.y, v22 = scene->view.v2.y, v23 = scene->view.v3.y,
          v31 = scene->view.v1.z, v32 = scene->view.v2.z, v33 = scene->view.v3.z;
   // Compute V*M, the modelview matrix.
   double mv11 = v11*m11 + v12*m21 + v13*m31,
          mv12 = v11*m12 + v12*m22 + v13*m32,
          mv13 = v11*m13 + v12*m23 + v13*m33,
          mv21 = v21*m11 + v22*m21 + v23*m31,
          mv22 = v21*m12 + v22*m22 + v23*m32,
          mv23 = v21*m13 + v22*m23 + v23*m33,
          mv31 = v31*m11 + v32*m21 + v33*m31,
          mv32 = v31*m12 + v32*m22 + v33*m32,
          mv33 = v31*m13 + v32*m23 + v33*m33;
   // Compute (V*M)^{-T}, the inverse transpose of the modelview matrix.
   // We are using the trick here of computing the inverse using cofactors,
   // but without dividing by the determinant. So this is not the true inverse,
   // but we only need our "inverse" to point our vectors in the correct direction.
   // We will then normalize our vectors to length 1.
   Vector col1 = Vector(mv22*mv33-mv23*mv32, mv13*mv32-mv12*mv33, mv12*mv23-mv13*mv22);
   Vector col2 = Vector(mv23*mv31-mv21*mv33, mv11*mv33-mv13*mv31, mv13*mv21-mv11*mv23);
   Vector col3 = Vector(mv21*mv32-mv22*mv31, mv12*mv31-mv11*mv32, mv11*mv22-mv12*mv21);
   Vector col4 = Vector(0.0, 0.0, 0.0, 1.0);
   Matrix MVInvTranspose = Matrix(col1, col2, col3, col4);

   TriangleListNode *ptr;
   for (ptr = (scene->head_node).next;  ptr && ptr->t->mtrl;  ptr = ptr->next)
   {


   }
   return;
}


void doFlatLighting(Scene *scene)
{
   TriangleListNode *ptr;
   for (ptr = (scene->head_node).next;  ptr && ptr->t->mtrl;  ptr = ptr->next)
   {
      // Compute a normal vector, N, for this triangle. We need to be carefull
      // that the normal vector has the right "orientation". We want the normal
      // vector for a CCW triangle (which is the default for a "forward facing
      // triangle") to point towards the origin (in view coordinates). Compare
      // with P3_BackFaceCulling.cpp. Another way to put this is that for a
      // closed surface made up of CCW triangles, the normal vector should
      // point outside of the surface.



   }
   return;
}