/*
 * Decompiled with CFR 0.152.
 */
public class Matrix {
    public Vector v1;
    public Vector v2;
    public Vector v3;
    public Vector v4;

    public Matrix() {
        this.v1 = new Vector();
        this.v2 = new Vector();
        this.v3 = new Vector();
        this.v4 = new Vector();
    }

    public Matrix(Vector v) {
        this.v1 = new Vector(1.0, 0.0, 0.0, 0.0);
        this.v2 = new Vector(0.0, 1.0, 0.0, 0.0);
        this.v3 = new Vector(0.0, 0.0, 1.0, 0.0);
        this.v4 = new Vector(v.x, v.y, v.z, 1.0);
    }

    public Matrix(double d) {
        this.v1 = new Vector(d, 0.0, 0.0, 0.0);
        this.v2 = new Vector(0.0, d, 0.0, 0.0);
        this.v3 = new Vector(0.0, 0.0, d, 0.0);
        this.v4 = new Vector(0.0, 0.0, 0.0, 1.0);
    }

    public Matrix(double x, double y, double z) {
        this.v1 = new Vector(x, 0.0, 0.0, 0.0);
        this.v2 = new Vector(0.0, y, 0.0, 0.0);
        this.v3 = new Vector(0.0, 0.0, z, 0.0);
        this.v4 = new Vector(0.0, 0.0, 0.0, 1.0);
    }

    public Matrix(double theta, double x, double y, double z) {
        double norm = Math.sqrt(x * x + y * y + z * z);
        double ux = x / norm;
        double uy = y / norm;
        double uz = z / norm;
        double c = Math.cos(Math.PI / 180 * theta);
        double s = Math.sin(Math.PI / 180 * theta);
        this.v1 = new Vector(ux * ux * (1.0 - c) + c, uy * ux * (1.0 - c) + uz * s, uz * ux * (1.0 - c) - uy * s, 0.0);
        this.v2 = new Vector(ux * uy * (1.0 - c) - uz * s, uy * uy * (1.0 - c) + c, uz * uy * (1.0 - c) + ux * s, 0.0);
        this.v3 = new Vector(ux * uz * (1.0 - c) + uy * s, uy * uz * (1.0 - c) - ux * s, uz * uz * (1.0 - c) + c, 0.0);
        this.v4 = new Vector(0.0, 0.0, 0.0, 1.0);
    }

    public Matrix(Vector _v1, Vector _v2, Vector _v3, Vector _v4) {
        this.v1 = _v1;
        this.v2 = _v2;
        this.v3 = _v3;
        this.v4 = _v4;
    }

    public void setColumn(int col, double x, double y, double z, double w) {
        if (col == 1) {
            this.v1.set(x, y, z, w);
        } else if (col == 2) {
            this.v2.set(x, y, z, w);
        } else if (col == 3) {
            this.v3.set(x, y, z, w);
        } else if (col == 4) {
            this.v4.set(x, y, z, w);
        }
    }

    public Matrix times(double s) {
        return new Matrix(this.v1.times(s), this.v2.times(s), this.v3.times(s), this.v4.times(s));
    }

    public Matrix times(Matrix m) {
        return new Matrix(this.times(m.v1), this.times(m.v2), this.times(m.v3), this.times(m.v4));
    }

    public Vector times(Vector v) {
        return this.v1.times(v.x).plus(this.v2.times(v.y).plus(this.v3.times(v.z).plus(this.v4.times(v.w))));
    }

    public Vertex times(Vertex v) {
        Vector sum = this.v1.times(v.x).plus(this.v2.times(v.y).plus(this.v3.times(v.z).plus(this.v4.times(v.w))));
        Vertex temp = new Vertex(sum.x, sum.y, sum.z, sum.w);
        temp.r = v.r;
        temp.g = v.g;
        temp.b = v.b;
        temp.a = v.a;
        temp.s = v.s;
        temp.t = v.t;
        temp.n = v.n;
        return temp;
    }

    public Matrix invTranspose() {
        double m11 = this.v1.x;
        double m12 = this.v2.x;
        double m13 = this.v3.x;
        double m21 = this.v1.y;
        double m22 = this.v2.y;
        double m23 = this.v3.y;
        double m31 = this.v1.z;
        double m32 = this.v2.z;
        double m33 = this.v3.z;
        Vector col1 = new Vector(m22 * m33 - m23 * m32, m13 * m32 - m12 * m33, m12 * m23 - m13 * m22);
        Vector col2 = new Vector(m23 * m31 - m21 * m33, m11 * m33 - m13 * m31, m13 * m21 - m11 * m23);
        Vector col3 = new Vector(m21 * m32 - m22 * m31, m12 * m31 - m11 * m32, m11 * m22 - m12 * m21);
        Vector col4 = new Vector(0.0, 0.0, 0.0, 1.0);
        double det = m11 * m22 * m33 + m12 * m23 * m31 + m13 * m21 * m32 - m13 * m22 * m31 - m12 * m21 * m33 - m11 * m23 * m32;
        col1 = col1.times(1.0 / det);
        col2 = col2.times(1.0 / det);
        col3 = col3.times(1.0 / det);
        return new Matrix(col1, col2, col3, col4);
    }

    public String toString() {
        String result = "";
        int p = 5;
        int w = p + 4;
        String format = "% " + w + "." + p + "f  % " + w + "." + p + "f  % " + w + "." + p + "f  % " + w + "." + p + "f";
        result = result + String.format("[[" + format + "]\n", this.v1.x, this.v2.x, this.v3.x, this.v4.x);
        result = result + String.format(" [" + format + "]\n", this.v1.y, this.v2.y, this.v3.y, this.v4.y);
        result = result + String.format(" [" + format + "]\n", this.v1.z, this.v2.z, this.v3.z, this.v4.z);
        result = result + String.format(" [" + format + "]]\n", this.v1.w, this.v2.w, this.v3.w, this.v4.w);
        return result;
    }
}

