/*
 * Decompiled with CFR 0.152.
 */
public class Vector {
    public double x;
    public double y;
    public double z;
    public double w;

    public Vector() {
        this.x = 0.0;
        this.y = 0.0;
        this.z = 0.0;
        this.w = 0.0;
    }

    public Vector(double x, double y, double z) {
        this.set(x, y, z, 0.0);
    }

    public Vector(double x, double y, double z, double w) {
        this.set(x, y, z, w);
    }

    public Vector(Vector v) {
        this.set(v.x, v.y, v.z, v.w);
    }

    public void set(double x, double y, double z, double w) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
    }

    public Vector times(double s) {
        return new Vector(s * this.x, s * this.y, s * this.z, s * this.w);
    }

    public Vector plus(Vector v) {
        return new Vector(this.x + v.x, this.y + v.y, this.z + v.z, this.w + v.w);
    }

    public Vector crossProduct(Vector v) {
        return new Vector(this.y * v.z - this.z * v.y, this.z * v.x - this.x * v.z, this.x * v.y - this.y * v.x);
    }

    public double dotProduct(Vector v) {
        return this.x * v.x + this.y * v.y + this.z * v.z;
    }

    public Vector normalize() {
        double norm = Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
        return new Vector(this.x / norm, this.y / norm, this.z / norm);
    }

    public String toString() {
        int p = 5;
        int t = p + 4;
        String format = "[x,y,z,w] = [% " + t + "." + p + "f  % " + t + "." + p + "f  % " + t + "." + p + "f  % " + t + "." + p + "f]\n";
        return String.format(format, this.x, this.y, this.z, this.w);
    }
}

