/*
 * Decompiled with CFR 0.152.
 */
public class P4_LightingFlat
implements PipelineStage {
    Scene scene;

    public P4_LightingFlat(Scene scene) {
        this.scene = scene;
    }

    @Override
    public Model processModel(Model model) {
        Light light = this.scene.light;
        Matrix viewMatrix = this.scene.viewMatrix;
        if (!model.doLighting || model.doSmoothLighting) {
            return model;
        }
        if (null == light) {
            System.err.println("Warning! Lighting is enabled but the Scene does not have a Light.");
            return model;
        }
        Vertex S = new Vertex(light.pos);
        S = viewMatrix.times(S);
        Vector S2 = new Vector(S.x, S.y, S.z);
        for (Triangle t : model.triangleList) {
            if (null == t.mtrl) {
                System.err.println("Warning! Lighting is enabled but a triangle does not have a Material.");
                continue;
            }
            double s = t.mtrl.s;
            double kar = t.mtrl.ambient[0];
            double kdr = t.mtrl.diffuse[0];
            double ksr = t.mtrl.specular[0];
            double car = light.ambient[0];
            double cdr = light.diffuse[0];
            double csr = light.specular[0];
            double kag = t.mtrl.ambient[1];
            double kdg = t.mtrl.diffuse[1];
            double ksg = t.mtrl.specular[1];
            double cag = light.ambient[1];
            double cdg = light.diffuse[1];
            double csg = light.specular[1];
            double kab = t.mtrl.ambient[2];
            double kdb = t.mtrl.diffuse[2];
            double ksb = t.mtrl.specular[2];
            double cab = light.ambient[2];
            double cdb = light.diffuse[2];
            double csb = light.specular[2];
            Vector q1 = new Vector(t.v[1].x - t.v[0].x, t.v[1].y - t.v[0].y, t.v[1].z - t.v[0].z);
            Vector q2 = new Vector(t.v[2].x - t.v[0].x, t.v[2].y - t.v[0].y, t.v[2].z - t.v[0].z);
            Vector N = q1.crossProduct(q2);
            N = N.normalize();
            Vector p0 = new Vector(t.v[0].x, t.v[0].y, t.v[0].z);
            Vector p1 = new Vector(t.v[1].x, t.v[1].y, t.v[1].z);
            Vector p2 = new Vector(t.v[2].x, t.v[2].y, t.v[2].z);
            Vector p = p0.times(0.3333333333333333).plus(p1.times(0.3333333333333333).plus(p2.times(0.3333333333333333)));
            if (model.doOpenglLighting && 0 == model.useVertexNumber) {
                p = p0;
            } else if (model.doOpenglLighting && 1 == model.useVertexNumber) {
                p = p1;
            } else if (model.doOpenglLighting && 2 == model.useVertexNumber) {
                p = p2;
            }
            Vector L = S2.plus(p.times(-1.0));
            L = L.normalize();
            Vector R = N.times(2.0 * L.dotProduct(N)).plus(L.times(-1.0));
            Vector V = p.normalize().times(-1.0);
            Vector H = L.plus(V).normalize();
            double diffuseAngle = L.dotProduct(N);
            diffuseAngle = diffuseAngle < 0.0 ? 0.0 : diffuseAngle;
            double shininess = model.useHalfVector ? N.dotProduct(H) : R.dotProduct(V);
            shininess = shininess < 0.0 ? 0.0 : Math.pow(shininess, s);
            double r = kar * car + kdr * cdr * diffuseAngle + ksr * csr * shininess;
            t.v[0].r = r = r <= 1.0 ? r : 1.0;
            t.v[1].r = r;
            t.v[2].r = r;
            double g = kag * cag + kdg * cdg * diffuseAngle + ksg * csg * shininess;
            t.v[0].g = g = g <= 1.0 ? g : 1.0;
            t.v[1].g = g;
            t.v[2].g = g;
            double b = kab * cab + kdb * cdb * diffuseAngle + ksb * csb * shininess;
            t.v[0].b = b = b <= 1.0 ? b : 1.0;
            t.v[1].b = b;
            t.v[2].b = b;
        }
        return model;
    }
}

