/*
 * Decompiled with CFR 0.152.
 */
public class P5_View2Clip
implements PipelineStage {
    Scene scene;

    public P5_View2Clip(Scene scene) {
        this.scene = scene;
    }

    @Override
    public Model processModel(Model model) {
        Matrix projMatrix = this.scene.projMatrix;
        for (Triangle t : model.triangleList) {
            t.v[0] = projMatrix.times(t.v[0]);
            t.v[1] = projMatrix.times(t.v[1]);
            t.v[2] = projMatrix.times(t.v[2]);
        }
        return model;
    }

    private void debug(Triangle t) {
        System.err.printf("x=% 6.2f, y=% 6.2f, x=% 6.2f, y=% 6.2f, x=% 6.2f, y=% 6.2f\n", t.v[0].x, t.v[0].y, t.v[1].x, t.v[1].y, t.v[2].x, t.v[2].y);
        Vertex v0 = t.v[0].times(1.0 / t.v[0].w);
        Vertex v1 = t.v[1].times(1.0 / t.v[1].w);
        Vertex v2 = t.v[2].times(1.0 / t.v[2].w);
        System.err.printf("x=% 8.5f, y=% 8.5f, x=% 8.5f, y=% 8.5f, x=% 8.5f, y=% 8.5f\n", v0.x, v0.y, v1.x, v1.y, v2.x, v2.y);
    }
}

