/*
 * Decompiled with CFR 0.152.
 */
import java.util.LinkedList;

public class P6_Clipping
implements PipelineStage {
    @Override
    public Model processModel(Model model) {
        LinkedList<Triangle> newTriangleList = new LinkedList<Triangle>();
        while (!model.triangleList.isEmpty()) {
            Triangle t = (Triangle)model.triangleList.removeFirst();
            double w0 = Math.abs(t.v[0].w);
            double w1 = Math.abs(t.v[1].w);
            double w2 = Math.abs(t.v[2].w);
            if (!(Math.abs(t.v[0].x) > w0 || Math.abs(t.v[0].y) > w0 || Math.abs(t.v[0].z) > w0 || Math.abs(t.v[1].x) > w1 || Math.abs(t.v[1].y) > w1 || Math.abs(t.v[1].z) > w1 || Math.abs(t.v[2].x) > w2 || Math.abs(t.v[2].y) > w2 || Math.abs(t.v[2].z) > w2)) {
                newTriangleList.add(t);
                continue;
            }
            w0 = t.v[0].w;
            w1 = t.v[1].w;
            w2 = t.v[2].w;
            if (w0 + t.v[0].x < 0.0 && w1 + t.v[1].x < 0.0 && w2 + t.v[2].x < 0.0 || w0 - t.v[0].x < 0.0 && w1 - t.v[1].x < 0.0 && w2 - t.v[2].x < 0.0 || w0 + t.v[0].y < 0.0 && w1 + t.v[1].y < 0.0 && w2 + t.v[2].y < 0.0 || w0 - t.v[0].y < 0.0 && w1 - t.v[1].y < 0.0 && w2 - t.v[2].y < 0.0 || w0 + t.v[0].z < 0.0 && w1 + t.v[1].z < 0.0 && w2 + t.v[2].z < 0.0 || w0 - t.v[0].z < 0.0 && w1 - t.v[1].z < 0.0 && w2 - t.v[2].z < 0.0) continue;
            if (w0 + t.v[0].x < 0.0 || w1 + t.v[1].x < 0.0 || w2 + t.v[2].x < 0.0) {
                if (w0 + t.v[0].x < 0.0 && w1 + t.v[1].x < 0.0) {
                    this.interpolateNewTriangle(t.v[2], t.v[0], t.v[1], t, model.triangleList, 1);
                    continue;
                }
                if (w0 + t.v[0].x < 0.0 && w2 + t.v[2].x < 0.0) {
                    this.interpolateNewTriangle(t.v[1], t.v[2], t.v[0], t, model.triangleList, 1);
                    continue;
                }
                if (w1 + t.v[1].x < 0.0 && w2 + t.v[2].x < 0.0) {
                    this.interpolateNewTriangle(t.v[0], t.v[1], t.v[2], t, model.triangleList, 1);
                    continue;
                }
                if (w0 + t.v[0].x < 0.0) {
                    this.interpolateNewTriangles(t.v[0], t.v[1], t.v[2], t, model.triangleList, 1);
                    continue;
                }
                if (w1 + t.v[1].x < 0.0) {
                    this.interpolateNewTriangles(t.v[1], t.v[2], t.v[0], t, model.triangleList, 1);
                    continue;
                }
                if (w2 + t.v[2].x < 0.0) {
                    this.interpolateNewTriangles(t.v[2], t.v[0], t.v[1], t, model.triangleList, 1);
                    continue;
                }
                System.err.println("Clipping to x = -1 dropped a triangle!");
                continue;
            }
            if (w0 - t.v[0].x < 0.0 || w1 - t.v[1].x < 0.0 || w2 - t.v[2].x < 0.0) {
                if (w0 - t.v[0].x < 0.0 && w1 - t.v[1].x < 0.0) {
                    this.interpolateNewTriangle(t.v[2], t.v[0], t.v[1], t, model.triangleList, 2);
                    continue;
                }
                if (w0 - t.v[0].x < 0.0 && w2 - t.v[2].x < 0.0) {
                    this.interpolateNewTriangle(t.v[1], t.v[2], t.v[0], t, model.triangleList, 2);
                    continue;
                }
                if (w1 - t.v[1].x < 0.0 && w2 - t.v[2].x < 0.0) {
                    this.interpolateNewTriangle(t.v[0], t.v[1], t.v[2], t, model.triangleList, 2);
                    continue;
                }
                if (w0 - t.v[0].x < 0.0) {
                    this.interpolateNewTriangles(t.v[0], t.v[1], t.v[2], t, model.triangleList, 2);
                    continue;
                }
                if (w1 - t.v[1].x < 0.0) {
                    this.interpolateNewTriangles(t.v[1], t.v[2], t.v[0], t, model.triangleList, 2);
                    continue;
                }
                if (w2 - t.v[2].x < 0.0) {
                    this.interpolateNewTriangles(t.v[2], t.v[0], t.v[1], t, model.triangleList, 2);
                    continue;
                }
                System.err.println("Clipping to x = +1 dropped a triangle!");
                continue;
            }
            if (w0 + t.v[0].y < 0.0 || w1 + t.v[1].y < 0.0 || w2 + t.v[2].y < 0.0) {
                if (w0 + t.v[0].y < 0.0 && w1 + t.v[1].y < 0.0) {
                    this.interpolateNewTriangle(t.v[2], t.v[0], t.v[1], t, model.triangleList, 3);
                    continue;
                }
                if (w0 + t.v[0].y < 0.0 && w2 + t.v[2].y < 0.0) {
                    this.interpolateNewTriangle(t.v[1], t.v[2], t.v[0], t, model.triangleList, 3);
                    continue;
                }
                if (w1 + t.v[1].y < 0.0 && w2 + t.v[2].y < 0.0) {
                    this.interpolateNewTriangle(t.v[0], t.v[1], t.v[2], t, model.triangleList, 3);
                    continue;
                }
                if (w0 + t.v[0].y < 0.0) {
                    this.interpolateNewTriangles(t.v[0], t.v[1], t.v[2], t, model.triangleList, 3);
                    continue;
                }
                if (w1 + t.v[1].y < 0.0) {
                    this.interpolateNewTriangles(t.v[1], t.v[2], t.v[0], t, model.triangleList, 3);
                    continue;
                }
                if (w2 + t.v[2].y < 0.0) {
                    this.interpolateNewTriangles(t.v[2], t.v[0], t.v[1], t, model.triangleList, 3);
                    continue;
                }
                System.err.println("Clipping to y = -1 dropped a triangle!");
                continue;
            }
            if (w0 - t.v[0].y < 0.0 || w1 - t.v[1].y < 0.0 || w2 - t.v[2].y < 0.0) {
                if (w0 - t.v[0].y < 0.0 && w1 - t.v[1].y < 0.0) {
                    this.interpolateNewTriangle(t.v[2], t.v[0], t.v[1], t, model.triangleList, 4);
                    continue;
                }
                if (w0 - t.v[0].y < 0.0 && w2 - t.v[2].y < 0.0) {
                    this.interpolateNewTriangle(t.v[1], t.v[2], t.v[0], t, model.triangleList, 4);
                    continue;
                }
                if (w1 - t.v[1].y < 0.0 && w2 - t.v[2].y < 0.0) {
                    this.interpolateNewTriangle(t.v[0], t.v[1], t.v[2], t, model.triangleList, 4);
                    continue;
                }
                if (w0 - t.v[0].y < 0.0) {
                    this.interpolateNewTriangles(t.v[0], t.v[1], t.v[2], t, model.triangleList, 4);
                    continue;
                }
                if (w1 - t.v[1].y < 0.0) {
                    this.interpolateNewTriangles(t.v[1], t.v[2], t.v[0], t, model.triangleList, 4);
                    continue;
                }
                if (w2 - t.v[2].y < 0.0) {
                    this.interpolateNewTriangles(t.v[2], t.v[0], t.v[1], t, model.triangleList, 4);
                    continue;
                }
                System.err.println("Clipping to y = +1 dropped a triangle!");
                continue;
            }
            if (w0 + t.v[0].z < 0.0 || w1 + t.v[1].z < 0.0 || w2 + t.v[2].z < 0.0) {
                if (w0 + t.v[0].z < 0.0 && w1 + t.v[1].z < 0.0) {
                    this.interpolateNewTriangle(t.v[2], t.v[0], t.v[1], t, model.triangleList, 5);
                    continue;
                }
                if (w0 + t.v[0].z < 0.0 && w2 + t.v[2].z < 0.0) {
                    this.interpolateNewTriangle(t.v[1], t.v[2], t.v[0], t, model.triangleList, 5);
                    continue;
                }
                if (w1 + t.v[1].z < 0.0 && w2 + t.v[2].z < 0.0) {
                    this.interpolateNewTriangle(t.v[0], t.v[1], t.v[2], t, model.triangleList, 5);
                    continue;
                }
                if (w0 + t.v[0].z < 0.0) {
                    this.interpolateNewTriangles(t.v[0], t.v[1], t.v[2], t, model.triangleList, 5);
                    continue;
                }
                if (w1 + t.v[1].z < 0.0) {
                    this.interpolateNewTriangles(t.v[1], t.v[2], t.v[0], t, model.triangleList, 5);
                    continue;
                }
                if (w2 + t.v[2].z < 0.0) {
                    this.interpolateNewTriangles(t.v[2], t.v[0], t.v[1], t, model.triangleList, 5);
                    continue;
                }
                System.err.println("Clipping to z = -1 dropped a triangle!");
                continue;
            }
            if (w0 - t.v[0].z < 0.0 || w1 - t.v[1].z < 0.0 || w2 - t.v[2].z < 0.0) {
                if (w0 - t.v[0].z < 0.0 && w1 - t.v[1].z < 0.0) {
                    this.interpolateNewTriangle(t.v[2], t.v[0], t.v[1], t, model.triangleList, 6);
                    continue;
                }
                if (w0 - t.v[0].z < 0.0 && w2 - t.v[2].z < 0.0) {
                    this.interpolateNewTriangle(t.v[1], t.v[2], t.v[0], t, model.triangleList, 6);
                    continue;
                }
                if (w1 - t.v[1].z < 0.0 && w2 - t.v[2].z < 0.0) {
                    this.interpolateNewTriangle(t.v[0], t.v[1], t.v[2], t, model.triangleList, 6);
                    continue;
                }
                if (w0 - t.v[0].z < 0.0) {
                    this.interpolateNewTriangles(t.v[0], t.v[1], t.v[2], t, model.triangleList, 6);
                    continue;
                }
                if (w1 - t.v[1].z < 0.0) {
                    this.interpolateNewTriangles(t.v[1], t.v[2], t.v[0], t, model.triangleList, 6);
                    continue;
                }
                if (w2 - t.v[2].z < 0.0) {
                    this.interpolateNewTriangles(t.v[2], t.v[0], t.v[1], t, model.triangleList, 6);
                    continue;
                }
                System.err.println("Clipping to z = +1 dropped a triangle!");
                continue;
            }
            System.err.println("Clipping error!");
            System.exit(-1);
        }
        model.triangleList = newTriangleList;
        return model;
    }

    private Vertex interpolateNewVertex(Vertex v_outside, Vertex v_inside, int eqn_number) {
        double vix = v_inside.x;
        double viy = v_inside.y;
        double viz = v_inside.z;
        double viw = v_inside.w;
        double vox = v_outside.x;
        double voy = v_outside.y;
        double voz = v_outside.z;
        double vow = v_outside.w;
        double t = 0.0;
        if (1 == eqn_number) {
            t = -(vow + vox) / (viw + vix - (vow + vox));
        } else if (2 == eqn_number) {
            t = -(vow - vox) / (viw - vix - (vow - vox));
        } else if (3 == eqn_number) {
            t = -(vow + voy) / (viw + viy - (vow + voy));
        } else if (4 == eqn_number) {
            t = -(vow - voy) / (viw - viy - (vow - voy));
        } else if (5 == eqn_number) {
            t = -(vow + voz) / (viw + viz - (vow + voz));
        } else if (6 == eqn_number) {
            t = -(vow - voz) / (viw - viz - (vow - voz));
        }
        Vertex v_new = new Vertex();
        v_new.x = (1.0 - (t += 1.0E-6)) * vox + t * vix;
        v_new.y = (1.0 - t) * voy + t * viy;
        v_new.z = (1.0 - t) * voz + t * viz;
        v_new.w = (1.0 - t) * vow + t * viw;
        v_new.r = (1.0 - t) * v_outside.r + t * v_inside.r;
        v_new.g = (1.0 - t) * v_outside.g + t * v_inside.g;
        v_new.b = (1.0 - t) * v_outside.b + t * v_inside.b;
        v_new.a = (1.0 - t) * v_outside.a + t * v_inside.a;
        v_new.s = (1.0 - t) * v_outside.s + t * v_inside.s;
        v_new.t = (1.0 - t) * v_outside.t + t * v_inside.t;
        if (null != v_outside.n && null != v_inside.n) {
            v_new.n = v_outside.n.times(1.0 - t).plus(v_inside.n.times(t));
        }
        return v_new;
    }

    private void interpolateNewTriangle(Vertex v0_inside, Vertex v1_outside, Vertex v2_outside, Triangle t, LinkedList<Triangle> triangleList, int eqn_number) {
        Vertex v1_new = this.interpolateNewVertex(v1_outside, v0_inside, eqn_number);
        Vertex v2_new = this.interpolateNewVertex(v2_outside, v0_inside, eqn_number);
        Triangle t_new = new Triangle(v0_inside, v1_new, v2_new);
        t_new.tex = t.tex;
        t_new.mtrl = t.mtrl;
        triangleList.addLast(t_new);
    }

    private void interpolateNewTriangles(Vertex v0_outside, Vertex v1_inside, Vertex v2_inside, Triangle t, LinkedList<Triangle> triangleList, int eqn_number) {
        Vertex v0_new1 = this.interpolateNewVertex(v0_outside, v1_inside, eqn_number);
        Triangle t1_new = new Triangle(v0_new1, v1_inside, v2_inside);
        t1_new.tex = t.tex;
        t1_new.mtrl = t.mtrl;
        Vertex v0_new2 = this.interpolateNewVertex(v0_outside, v2_inside, eqn_number);
        Triangle t2_new = new Triangle(v0_new1, v0_new2, v2_inside);
        t2_new.tex = t.tex;
        t2_new.mtrl = t.mtrl;
        triangleList.addLast(t1_new);
        triangleList.addLast(t2_new);
    }
}

