/*
 * Decompiled with CFR 0.152.
 */
public class P8_NDC2VP
implements PipelineStage {
    FrameBuffer fb;

    public P8_NDC2VP(FrameBuffer fb) {
        this.fb = fb;
    }

    @Override
    public Model processModel(Model model) {
        int vpWidth = this.fb.getWidthVP();
        int vpHeight = this.fb.getHeightVP();
        for (Triangle t : model.triangleList) {
            t.v[0].x = (double)vpWidth / 2.0 * (t.v[0].x + 1.0);
            t.v[0].y = (double)vpHeight / 2.0 * (t.v[0].y + 1.0);
            t.v[1].x = (double)vpWidth / 2.0 * (t.v[1].x + 1.0);
            t.v[1].y = (double)vpHeight / 2.0 * (t.v[1].y + 1.0);
            t.v[2].x = (double)vpWidth / 2.0 * (t.v[2].x + 1.0);
            t.v[2].y = (double)vpHeight / 2.0 * (t.v[2].y + 1.0);
        }
        return model;
    }

    private static void debug(Triangle t) {
        System.err.printf("x=% 6.1f, y=% 6.1f, x=% 6.1f, y=% 6.1f, x=% 6.1f, y=% 6.1f\n", t.v[0].x, t.v[0].y, t.v[1].x, t.v[1].y, t.v[2].x, t.v[2].y);
    }
}

