/*
 * Decompiled with CFR 0.152.
 */
import java.util.Vector;

public class SceneRender {
    private Vector<PipelineStage> pipeline = new Vector();
    private Scene scene;
    private FrameBuffer fb;

    public SceneRender(Scene scene) {
        this.scene = scene;
    }

    public SceneRender(Scene scene, FrameBuffer fb) {
        this.scene = scene;
        this.fb = fb;
        this.pipeline.add(new P0_DuplicateModel());
        this.pipeline.add(new P1_Model2World());
        this.pipeline.add(new P2_World2View(scene));
        this.pipeline.add(new P3_BackFaceCulling());
        this.pipeline.add(new P4_LightingFlat(scene));
        this.pipeline.add(new P4_LightingSmooth(scene));
        this.pipeline.add(new P5_View2Clip(scene));
        this.pipeline.add(new P6_Clipping());
        this.pipeline.add(new P7_Clip2NDC());
        this.pipeline.add(new P8_NDC2VP(fb));
        this.pipeline.add(new P9_Rasterize());
        this.pipeline.add(new P10_FragmentShaderColor());
        this.pipeline.add(new P10_FragmentShaderTexture());
        this.pipeline.add(new P11_Fragments2FB(fb));
    }

    public Scene renderScene() {
        System.err.print(this.scene.printMatrices());
        Scene renderedScene = new Scene(this.scene);
        int modelNumber = 1;
        for (Model model : this.scene.modelList) {
            System.err.print(model.printMatrices());
            int stageNumber = 0;
            for (PipelineStage ps : this.pipeline) {
                model = ps.processModel(model);
                SceneRender.printVertices(model, stageNumber);
                ++stageNumber;
            }
            renderedScene.addModel(model);
            ++modelNumber;
        }
        return renderedScene;
    }

    public void addPipelineStage(PipelineStage ps) {
        this.pipeline.add(ps);
    }

    public void replacePipelineStage(int index, PipelineStage ps) {
        this.pipeline.set(index, ps);
    }

    public void insertPipelineStage(int index, PipelineStage ps) {
        this.pipeline.add(index, ps);
    }

    public PipelineStage removePipelineStage(int index) {
        return this.pipeline.remove(index);
    }

    public String toString() {
        String result = "";
        for (PipelineStage ps : this.pipeline) {
            result = result + ps.getClass().getName() + "\n";
        }
        return result;
    }

    public static void printVertices(Model model, int stageNo) {
        int stageFlag = 1;
        for (int i = 1; i < stageNo; ++i) {
            stageFlag <<= 1;
        }
        String debugString = null;
        int debugStages = 0;
        debugString = System.getenv("PipeLine1");
        if (debugString != null) {
            ++debugStages;
        }
        if ((debugString = System.getenv("PipeLine2")) != null) {
            debugStages += 2;
        }
        if ((debugString = System.getenv("PipeLine3")) != null) {
            debugStages += 4;
        }
        if ((debugString = System.getenv("PipeLine4")) != null) {
            debugStages += 8;
        }
        if ((debugString = System.getenv("PipeLine5")) != null) {
            debugStages += 16;
        }
        if ((debugString = System.getenv("PipeLine6")) != null) {
            debugStages += 32;
        }
        if ((debugString = System.getenv("PipeLine7")) != null) {
            debugStages += 64;
        }
        if ((debugString = System.getenv("PipeLine8")) != null) {
            debugStages += 128;
        }
        if ((debugString = System.getenv("PipeLine9")) != null) {
            debugStages += 256;
        }
        if ((debugString = System.getenv("PipeLine10")) != null) {
            debugStages += 512;
        }
        if ((debugString = System.getenv("PipeLine11")) != null) {
            debugStages += 1024;
        }
        if ((debugString = System.getenv("PipeLine12")) != null) {
            debugStages += 2048;
        }
        if ((debugString = System.getenv("PipeLine13")) != null) {
            debugStages += 4096;
        }
        if ((debugString = System.getenv("PipeLine14")) != null) {
            debugStages += 8192;
        }
        if ((debugString = System.getenv("PipeLine15")) != null) {
            debugStages += 16384;
        }
        if ((debugString = System.getenv("PipeLine16")) != null) {
            debugStages += 32768;
        }
        if ((stageFlag & debugStages) != 0) {
            System.err.printf("================= Stage P%d begin ===========\n", stageNo);
            System.err.print(model.printVertices());
            System.err.printf("================= Stage P%d end =============\n", stageNo);
        }
    }
}

