/*
 * Decompiled with CFR 0.152.
 */
public class CylinderSectionModel
extends Model {
    public CylinderSectionModel(int k, int n, double radius, double h) {
        this(k, n, radius, h, 0.0, Math.PI * 2);
    }

    public CylinderSectionModel(int k, int n, double radius, double h, double theta1, double theta2) {
        int j;
        Triangle t;
        Vertex[][] v = new Vertex[n + 1][k + 1];
        double deltaTheta = (theta2 - theta1) / (double)k;
        for (int j2 = 0; j2 <= k; ++j2) {
            double c = Math.cos(theta1 + (double)j2 * deltaTheta);
            double s = Math.sin(theta1 + (double)j2 * deltaTheta);
            for (int i = 0; i <= n; ++i) {
                v[i][j2] = new Vertex(radius * c, h - (double)i * (2.0 * h / (double)n), radius * s);
                v[i][j2].n = new Vector(c, 0.0, s);
            }
        }
        Vertex topCenter = new Vertex(0.0, h, 0.0);
        topCenter.n = new Vector(0.0, 1.0, 0.0);
        Vertex bottomCenter = new Vertex(0.0, -h, 0.0);
        bottomCenter.n = new Vector(0.0, -1.0, 0.0);
        for (int i = 0; i < n; ++i) {
            for (int j3 = 0; j3 < k; ++j3) {
                t = new Triangle(v[i][j3], v[i][j3 + 1], v[i + 1][j3 + 1]);
                this.triangleList.add(t);
                t = new Triangle(v[i + 1][j3 + 1], v[i + 1][j3], v[i][j3]);
                this.triangleList.add(t);
            }
        }
        for (j = 0; j < k; ++j) {
            v[0][j + 1].n = new Vector(0.0, 1.0, 0.0);
            v[0][j].n = new Vector(0.0, 1.0, 0.0);
            t = new Triangle(topCenter, v[0][j + 1], v[0][j]);
            this.triangleList.add(t);
        }
        for (j = 0; j < k; ++j) {
            v[n][j].n = new Vector(0.0, -1.0, 0.0);
            v[n][j + 1].n = new Vector(0.0, -1.0, 0.0);
            t = new Triangle(bottomCenter, v[n][j], v[n][j + 1]);
            this.triangleList.add(t);
        }
    }
}

