/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;

public class FrameBuffer {
    public int width;
    public int height;
    public int[] pixel_buffer;
    public double[] z_buffer;
    private int vp_ul_x;
    private int vp_ul_y;
    private int vp_lr_x;
    private int vp_lr_y;

    public FrameBuffer(int w, int h) {
        this.width = w;
        this.height = h;
        this.vp_ul_x = 0;
        this.vp_ul_y = 0;
        this.vp_lr_x = this.width - 1;
        this.vp_lr_y = this.height - 1;
        this.pixel_buffer = new int[this.width * this.height * 3];
        this.z_buffer = new double[this.width * this.height];
        this.clearFB(Color.black);
    }

    public int getWidthFB() {
        return this.width;
    }

    public int getHeightFB() {
        return this.height;
    }

    public void clearFB(Color c) {
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                int index = (y * this.width + x) * 3;
                this.pixel_buffer[index + 0] = c.getRed();
                this.pixel_buffer[index + 1] = c.getGreen();
                this.pixel_buffer[index + 2] = c.getBlue();
            }
        }
        this.clearzFB();
    }

    public void clearzFB() {
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                this.z_buffer[y * this.width + x] = 1.0;
            }
        }
    }

    public void setViewport(int vp_ul_x, int vp_ul_y, int width, int height) {
        this.vp_ul_x = vp_ul_x;
        this.vp_ul_y = vp_ul_y;
        this.vp_lr_x = vp_ul_x + width - 1;
        this.vp_lr_y = vp_ul_y + height - 1;
    }

    public int getWidthVP() {
        return this.vp_lr_x - this.vp_ul_x + 1;
    }

    public int getHeightVP() {
        return this.vp_lr_y - this.vp_ul_y + 1;
    }

    public void clearVP(Color c) {
        for (int y = this.vp_ul_y; y <= this.vp_lr_y; ++y) {
            for (int x = this.vp_ul_x; x <= this.vp_lr_x; ++x) {
                int index = (y * this.width + x) * 3;
                this.pixel_buffer[index + 0] = c.getRed();
                this.pixel_buffer[index + 1] = c.getGreen();
                this.pixel_buffer[index + 2] = c.getBlue();
            }
        }
        this.clearzVP();
    }

    public void clearzVP() {
        for (int y = this.vp_ul_y; y <= this.vp_lr_y; ++y) {
            for (int x = this.vp_ul_x; x <= this.vp_lr_x; ++x) {
                this.z_buffer[y * this.width + x] = 1.0;
            }
        }
    }

    public Color getPixelFB(int x, int y) {
        int index = (y * this.width + x) * 3;
        int r = this.pixel_buffer[index + 0];
        int g = this.pixel_buffer[index + 1];
        int b = this.pixel_buffer[index + 2];
        return new Color(r, g, b);
    }

    public double getDepthFB(int x, int y) {
        return this.z_buffer[y * this.width + x];
    }

    public void setPixelFB(int x, int y, Color c) {
        int index = (y * this.width + x) * 3;
        this.pixel_buffer[index + 0] = c.getRed();
        this.pixel_buffer[index + 1] = c.getGreen();
        this.pixel_buffer[index + 2] = c.getBlue();
    }

    public void setPixelFB(int x, int y, double z) {
        int index = (y * this.width + x) * 3;
        this.z_buffer[y * this.width + x] = z;
    }

    public void setPixelFB(int x, int y, Color c, double z) {
        int index = (y * this.width + x) * 3;
        this.pixel_buffer[index + 0] = c.getRed();
        this.pixel_buffer[index + 1] = c.getGreen();
        this.pixel_buffer[index + 2] = c.getBlue();
        this.z_buffer[y * this.width + x] = z;
    }

    public Color getPixelVP(int x, int y) {
        int index = ((this.vp_ul_y + y) * this.width + this.vp_ul_x + x) * 3;
        int r = this.pixel_buffer[index + 0];
        int g = this.pixel_buffer[index + 1];
        int b = this.pixel_buffer[index + 2];
        return new Color(r, g, b);
    }

    public double getDepthVP(int x, int y) {
        return this.z_buffer[(this.vp_ul_y + y) * this.width + this.vp_ul_x + x];
    }

    public void setPixelVP(int x, int y, Color c) {
        int index = ((this.vp_ul_y + y) * this.width + this.vp_ul_x + x) * 3;
        this.pixel_buffer[index + 0] = c.getRed();
        this.pixel_buffer[index + 1] = c.getGreen();
        this.pixel_buffer[index + 2] = c.getBlue();
    }

    public void setPixelVP(int x, int y, double z) {
        int index = ((this.vp_ul_y + y) * this.width + this.vp_ul_x + x) * 3;
        this.z_buffer[(this.vp_ul_y + y) * this.width + this.vp_ul_x + x] = z;
    }

    public void setPixelVP(int x, int y, Color c, double z) {
        int index = ((this.vp_ul_y + y) * this.width + this.vp_ul_x + x) * 3;
        this.pixel_buffer[index + 0] = c.getRed();
        this.pixel_buffer[index + 1] = c.getGreen();
        this.pixel_buffer[index + 2] = c.getBlue();
        this.z_buffer[(this.vp_ul_y + y) * this.width + this.vp_ul_x + x] = z;
    }

    public FrameBuffer convertZB2FB() {
        int i;
        FrameBuffer zfb = new FrameBuffer(this.width, this.height);
        zfb.setViewport(this.vp_ul_x, this.vp_ul_y, this.vp_lr_x, this.vp_lr_y);
        for (i = 0; i < this.z_buffer.length; ++i) {
            int gray;
            zfb.pixel_buffer[3 * i + 0] = gray = (int)(127.5 + 127.5 * this.z_buffer[i]);
            zfb.pixel_buffer[3 * i + 1] = gray;
            zfb.pixel_buffer[3 * i + 2] = gray;
        }
        for (i = 0; i < this.z_buffer.length; ++i) {
            zfb.z_buffer[i] = this.z_buffer[i];
        }
        return zfb;
    }

    public FrameBuffer convertVP2FB() {
        FrameBuffer vp_fb = new FrameBuffer(this.getWidthVP(), this.getHeightVP());
        for (int y = 0; y < this.getHeightVP(); ++y) {
            for (int x = 0; x < this.getWidthVP(); ++x) {
                vp_fb.setPixelVP(x, y, this.getPixelVP(x, y), this.getDepthVP(x, y));
            }
        }
        return vp_fb;
    }

    public void dumpFB2File(String filename) {
        this.dumpPixels2File(0, 0, this.width - 1, this.height - 1, filename);
    }

    public void dumpVP2File(String filename) {
        this.dumpPixels2File(this.vp_ul_x, this.vp_ul_y, this.vp_lr_x, this.vp_lr_y, filename);
    }

    public void dumpPixels2File(int ul_x, int ul_y, int lr_x, int lr_y, String filename) {
        int p_width = lr_x - ul_x + 1;
        int p_height = lr_y - ul_y + 1;
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(filename);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace(System.err);
            System.err.printf("ERROR! Could not open file %s\n", filename);
            System.exit(-1);
        }
        try {
            fos.write(("P6\n" + p_width + " " + p_height + "\n" + 255 + "\n").getBytes());
            byte[] temp = new byte[p_width * 3];
            for (int n = 0; n < p_height; ++n) {
                for (int i = 0; i < temp.length; ++i) {
                    temp[i] = (byte)this.pixel_buffer[((lr_y - n) * this.width + ul_x) * 3 + i];
                }
                fos.write(temp);
            }
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
            System.err.printf("ERROR! Could not write to file %s\n", filename);
            System.exit(-1);
        }
        try {
            fos.close();
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
            System.err.printf("ERROR! Could not close file %s\n", filename);
            System.exit(-1);
        }
    }

    public void fbTest() {
        int w = this.width;
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                int gray;
                this.pixel_buffer[(y * w + x) * 3 + 0] = gray = (x | y) % 255;
                this.pixel_buffer[(y * w + x) * 3 + 1] = gray;
                this.pixel_buffer[(y * w + x) * 3 + 2] = gray;
            }
        }
    }

    public static void main(String[] args) {
        int i;
        int w = 512;
        int h = 512;
        FrameBuffer fb = new FrameBuffer(w, h);
        fb.fbTest();
        fb.dumpFB2File("test0.ppm");
        fb.setViewport(64, 64, 191, 319);
        fb.clearVP(Color.red);
        fb.dumpFB2File("test1.ppm");
        fb.dumpVP2File("test2.ppm");
        fb.dumpPixels2File(32, 192, 447, 319, "test3.ppm");
        for (i = 0; i < 383; ++i) {
            fb.setPixelFB(i, 128, Color.blue, 0.0);
        }
        fb.dumpFB2File("test4.ppm");
        for (i = 0; i < 255; ++i) {
            fb.setPixelVP(64, i, Color.blue, 0.0);
        }
        fb.dumpFB2File("test5.ppm");
        fb.dumpVP2File("test6.ppm");
    }
}

