/*
 * Decompiled with CFR 0.152.
 */
public class P10_FragmentShaderTexture
implements PipelineStage {
    @Override
    public Model processModel(Model model) {
        int triangleCounter = 0;
        for (Triangle triangle : model.triangleList) {
            ++triangleCounter;
            if (null == triangle.tex) continue;
            double s0 = triangle.v[0].s;
            double t0 = triangle.v[0].t;
            double s1 = triangle.v[1].s;
            double t1 = triangle.v[1].t;
            double s2 = triangle.v[2].s;
            double t2 = triangle.v[2].t;
            for (Fragment frag : triangle.fragments) {
                double alpha = frag.alpha;
                double beta = frag.beta;
                double gamma = frag.gamma;
                double s = alpha * s0 + beta * s1 + gamma * s2;
                double t = alpha * t0 + beta * t1 + gamma * t2;
                s -= Math.floor(s);
                t -= Math.floor(t);
                int y = (int)(t * (double)triangle.tex.height);
                int x = (int)(s * (double)triangle.tex.width);
                int index = (y * triangle.tex.width + x) * 3;
                int r = triangle.tex.data[index + 0];
                int g = triangle.tex.data[index + 1];
                int b = triangle.tex.data[index + 2];
                if (r < 0) {
                    r = 256 + r;
                }
                if (g < 0) {
                    g = 256 + g;
                }
                if (b < 0) {
                    b = 256 + b;
                }
                frag.r = (double)r / 255.0;
                frag.g = (double)g / 255.0;
                frag.b = (double)b / 255.0;
                frag.a = 1.0;
            }
        }
        return model;
    }
}

