/*
 * Decompiled with CFR 0.152.
 */
public class P4_LightingSmooth
implements PipelineStage {
    Scene scene;

    public P4_LightingSmooth(Scene scene) {
        this.scene = scene;
    }

    @Override
    public Model processModel(Model model) {
        Light light = this.scene.light;
        Matrix viewMatrix = this.scene.viewMatrix;
        if (!model.doLighting || !model.doSmoothLighting) {
            return model;
        }
        if (null == light) {
            System.err.println("Warning! Lighting is enabled but the Scene does not have a Light.");
            return model;
        }
        Vertex S = new Vertex(light.pos);
        S = viewMatrix.times(S);
        Vector S2 = new Vector(S.x, S.y, S.z);
        block0: for (Triangle t : model.triangleList) {
            if (null == t.mtrl) {
                System.err.println("Warning! Lighting is enabled but a triangle does not have a Material.");
                continue;
            }
            if (null == t.v[0].n || null == t.v[1].n || null == t.v[2].n) {
                System.err.println("Warning! Smooth lighting is enabled but a vertex does not have a normal vector.");
                continue;
            }
            double s = t.mtrl.s;
            double kar = t.mtrl.ambient[0];
            double kdr = t.mtrl.diffuse[0];
            double ksr = t.mtrl.specular[0];
            double car = light.ambient[0];
            double cdr = light.diffuse[0];
            double csr = light.specular[0];
            double kag = t.mtrl.ambient[1];
            double kdg = t.mtrl.diffuse[1];
            double ksg = t.mtrl.specular[1];
            double cag = light.ambient[1];
            double cdg = light.diffuse[1];
            double csg = light.specular[1];
            double kab = t.mtrl.ambient[2];
            double kdb = t.mtrl.diffuse[2];
            double ksb = t.mtrl.specular[2];
            double cab = light.ambient[2];
            double cdb = light.diffuse[2];
            double csb = light.specular[2];
            for (int i = 0; i < 3; ++i) {
                Vector p = new Vector(t.v[i].x, t.v[i].y, t.v[i].z);
                Vector N = t.v[i].n;
                Vector L = S2.plus(p.times(-1.0));
                L = L.normalize();
                Vector R = N.times(2.0 * L.dotProduct(N)).plus(L.times(-1.0));
                Vector V = p.normalize().times(-1.0);
                Vector H = L.plus(V).normalize();
                double diffuseAngle = L.dotProduct(N);
                diffuseAngle = diffuseAngle < 0.0 ? 0.0 : diffuseAngle;
                double shininess = model.useHalfVector ? N.dotProduct(H) : R.dotProduct(V);
                shininess = shininess < 0.0 ? 0.0 : Math.pow(shininess, s);
                double r = kar * car + kdr * cdr * diffuseAngle + ksr * csr * shininess;
                t.v[i].r = r = r <= 1.0 ? r : 1.0;
                double g = kag * cag + kdg * cdg * diffuseAngle + ksg * csg * shininess;
                t.v[i].g = g = g <= 1.0 ? g : 1.0;
                double b = kab * cab + kdb * cdb * diffuseAngle + ksb * csb * shininess;
                t.v[i].b = b = b <= 1.0 ? b : 1.0;
                if (!model.doOpenglLighting || i != model.useVertexNumber) continue;
                int j = i + 1;
                if (3 == j) {
                    j = 0;
                }
                t.v[j].r = r;
                t.v[j].g = g;
                t.v[j].b = b;
                if (3 == ++j) {
                    j = 0;
                }
                t.v[j].r = r;
                t.v[j].g = g;
                t.v[j].b = b;
                continue block0;
            }
        }
        return model;
    }
}

