/*
 * Decompiled with CFR 0.152.
 */
import java.util.LinkedList;

public class P9_Rasterize
implements PipelineStage {
    @Override
    public Model processModel(Model model) {
        int triangleCounter = 0;
        for (Triangle t : model.triangleList) {
            int yMax;
            int xMax;
            int yMin;
            ++triangleCounter;
            t.fragments = new LinkedList();
            double x1 = t.v[1].x;
            double x0 = t.v[0].x;
            double y2 = t.v[2].y;
            double y0 = t.v[0].y;
            double y1 = t.v[1].y;
            double x2 = t.v[2].x;
            double area = (x1 - x0) * (y2 - y0) - (y1 - y0) * (x2 - x0);
            if (1.0E-4 > Math.abs(area)) continue;
            int xMin = (int)x0;
            if (x1 < (double)xMin) {
                xMin = (int)x1;
            }
            if (x2 < (double)xMin) {
                xMin = (int)x2;
            }
            if (y1 < (double)(yMin = (int)y0)) {
                yMin = (int)y1;
            }
            if (y2 < (double)yMin) {
                yMin = (int)y2;
            }
            if (x1 > (double)(xMax = (int)Math.ceil(x0))) {
                xMax = (int)Math.ceil(x1);
            }
            if (x2 > (double)xMax) {
                xMax = (int)Math.ceil(x2);
            }
            if (y1 > (double)(yMax = (int)Math.ceil(y0))) {
                yMax = (int)Math.ceil(y1);
            }
            if (y2 > (double)yMax) {
                yMax = (int)Math.ceil(y2);
            }
            for (int y = yMax - 1; y >= yMin; --y) {
                for (int x = xMin; x < xMax; ++x) {
                    double alpha = ((y1 - y2) * (double)x + (x2 - x1) * (double)y + x1 * y2 - x2 * y1) / ((y1 - y2) * x0 + (x2 - x1) * y0 + x1 * y2 - x2 * y1);
                    double beta = ((y2 - y0) * (double)x + (x0 - x2) * (double)y + x2 * y0 - x0 * y2) / ((y2 - y0) * x1 + (x0 - x2) * y1 + x2 * y0 - x0 * y2);
                    double gamma = ((y0 - y1) * (double)x + (x1 - x0) * (double)y + x0 * y1 - x1 * y0) / ((y0 - y1) * x2 + (x1 - x0) * y2 + x0 * y1 - x1 * y0);
                    if (!(alpha >= 0.0) || !(beta >= 0.0) || !(gamma >= 0.0)) continue;
                    Fragment frag = new Fragment();
                    frag.xIndex = x;
                    frag.yIndex = y;
                    frag.zCoord = alpha * t.v[0].z + beta * t.v[1].z + gamma * t.v[2].z;
                    frag.alpha = alpha;
                    frag.beta = beta;
                    frag.gamma = gamma;
                    frag.r = 0.0;
                    frag.g = 0.0;
                    frag.b = 0.0;
                    frag.a = 0.0;
                    t.fragments.add(frag);
                }
            }
        }
        return model;
    }
}

