/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ObjSimpleModel
extends Model {
    public ObjSimpleModel(File modelFile) {
        this(modelFile, false);
    }

    public ObjSimpleModel(File modelFile, boolean colorFaces) {
        String objName = null;
        FileInputStream fis = null;
        try {
            objName = modelFile.getCanonicalPath();
            fis = new FileInputStream(modelFile);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace(System.err);
            System.err.printf("ERROR! Could not open OBJ file: %s\n", objName);
            System.exit(-1);
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
            System.err.printf("ERROR! Could not open OBJ file: %s\n", objName);
            System.exit(-1);
        }
        ArrayList<Vertex> verts = new ArrayList<Vertex>();
        try {
            Pattern p = Pattern.compile("^(\\d*)[/]?(\\d*)[/]?(\\d*)");
            Scanner scanner = new Scanner(fis);
            while (scanner.hasNext()) {
                String vn;
                String vt;
                Matcher m;
                String token = scanner.next();
                if (token.startsWith("#")) {
                    scanner.nextLine();
                    continue;
                }
                if (token.startsWith("v")) {
                    double x = scanner.nextDouble();
                    double y = scanner.nextDouble();
                    double z = scanner.nextDouble();
                    Vertex v = new Vertex(x, y, z);
                    verts.add(v);
                    continue;
                }
                if (!token.startsWith("f")) continue;
                String restOfLine = scanner.nextLine();
                Scanner scanner2 = new Scanner(restOfLine);
                int[] v = new int[3];
                for (int i = 0; i < 3; ++i) {
                    String faceGroup = scanner2.next();
                    m = p.matcher(faceGroup);
                    if (m.find()) {
                        v[i] = Integer.parseInt(m.group(1));
                        vt = m.group(2);
                        vn = m.group(3);
                        continue;
                    }
                    System.err.println("Error: bad face: " + faceGroup);
                }
                if (colorFaces) {
                    ((Vertex)verts.get(v[0] - 1)).setColorRandom();
                    ((Vertex)verts.get(v[1] - 1)).setColor((Vertex)verts.get(v[0] - 1));
                    ((Vertex)verts.get(v[2] - 1)).setColor((Vertex)verts.get(v[0] - 1));
                }
                Triangle t = new Triangle((Vertex)verts.get(v[0] - 1), (Vertex)verts.get(v[1] - 1), (Vertex)verts.get(v[2] - 1));
                this.triangleList.add(t);
                while (scanner2.hasNext()) {
                    v[1] = v[2];
                    String faceGroup = scanner2.next();
                    m = p.matcher(faceGroup);
                    if (m.find()) {
                        v[2] = Integer.parseInt(m.group(1));
                        vt = m.group(2);
                        vn = m.group(3);
                    } else {
                        System.err.println("Error: bad face: " + faceGroup);
                    }
                    if (colorFaces) {
                        ((Vertex)verts.get(v[2] - 1)).setColor((Vertex)verts.get(v[0] - 1));
                    }
                    t = new Triangle((Vertex)verts.get(v[0] - 1), (Vertex)verts.get(v[1] - 1), (Vertex)verts.get(v[2] - 1));
                    this.triangleList.add(t);
                }
            }
            fis.close();
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
            System.err.printf("ERROR! Could not read OBJ file: %s\n", objName);
            System.exit(-1);
        }
    }
}

