/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;

public class PanelModel
extends Model {
    public PanelModel(int xMin, int xMax, int zMin, int zMax, Color c1, Color c2) {
        this(xMin, xMax, zMin, zMax, c1, c2, null, null);
    }

    public PanelModel(int xMin, int xMax, int zMin, int zMax, Color c, Texture tex) {
        this(xMin, xMax, zMin, zMax, c, null, tex, null);
    }

    public PanelModel(int xMin, int xMax, int zMin, int zMax, Texture tex1, Texture tex2) {
        this(xMin, xMax, zMin, zMax, null, null, tex1, tex2);
    }

    public PanelModel(int xMin, int xMax, int zMin, int zMax, Color c1, Color c2, Texture tex1, Texture tex2) {
        int z;
        int x;
        Vertex[][] v = new Vertex[xMax - xMin + 1][zMax - zMin + 1];
        Vector normal = new Vector(0.0, 1.0, 0.0);
        for (x = xMin; x <= xMax; ++x) {
            for (z = zMin; z <= zMax; ++z) {
                v[x - xMin][z - zMin] = new Vertex((double)x, 0.0, (double)z);
                v[x - xMin][z - zMin].n = normal;
                v[x - xMin][z - zMin].setColorRandom();
            }
        }
        for (x = 0; x < xMax - zMin; ++x) {
            for (z = 0; z < zMax - zMin; ++z) {
                Triangle t1 = new Triangle(v[x][z], v[x][z + 1], v[x + 1][z + 1]);
                Triangle t2 = new Triangle(v[x + 1][z + 1], v[x + 1][z], v[x][z]);
                if ((x + z) % 2 == 0) {
                    if (null != c1) {
                        t1.setColor(c1);
                        t2.setColor(c1);
                    } else if (null != tex1) {
                        t1.setTexture(tex1);
                        t2.setTexture(tex1);
                    }
                } else if (null != c2) {
                    t1.setColor(c2);
                    t2.setColor(c2);
                } else if (null != tex2) {
                    t1.setTexture(tex2);
                    t2.setTexture(tex2);
                }
                this.triangleList.add(t1);
                this.triangleList.add(t2);
            }
        }
    }
}

