/*
 * Decompiled with CFR 0.152.
 */
public class SphereSectionModel
extends Model {
    public SphereSectionModel(int k, int n, double radius) {
        this(k, n, radius, 0.0, Math.PI * 2, 0.0, Math.PI);
    }

    public SphereSectionModel(int k, int n, double radius, double theta1, double theta2, double phi1, double phi2) {
        Triangle t;
        double deltaPhi = (phi2 - phi1) / (double)n;
        double deltaTheta = (theta2 - theta1) / (double)k;
        double phiStart = phi1;
        double phiEnd = phi2;
        if (0.0 == phi1) {
            phiStart = deltaPhi;
            --n;
        }
        if (Math.PI == phi2) {
            phiEnd = Math.PI - deltaPhi;
            --n;
        }
        Vertex[][] v = new Vertex[n + 1][k + 1];
        for (int j = 0; j <= k; ++j) {
            double c1 = Math.cos(theta1 + (double)j * deltaTheta);
            double s1 = Math.sin(theta1 + (double)j * deltaTheta);
            for (int i = 0; i <= n; ++i) {
                double c2 = Math.cos(phiStart + (double)i * deltaPhi);
                double s2 = Math.sin(phiStart + (double)i * deltaPhi);
                v[i][j] = new Vertex(radius * s2 * c1, radius * c2, radius * s2 * s1);
                v[i][j].n = new Vector(s2 * c1, c2, s2 * s1);
            }
        }
        Vertex topPole = new Vertex(0.0, radius, 0.0);
        Vertex bottomPole = new Vertex(0.0, -radius, 0.0);
        topPole.n = new Vector(0.0, 1.0, 0.0);
        bottomPole.n = new Vector(0.0, -1.0, 0.0);
        if (0.0 == phi1) {
            for (int j = 0; j < k; ++j) {
                t = new Triangle(topPole, v[0][j + 1], v[0][j]);
                this.triangleList.add(t);
            }
        }
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < k; ++j) {
                t = new Triangle(v[i][j], v[i][j + 1], v[i + 1][j + 1]);
                this.triangleList.add(t);
                t = new Triangle(v[i + 1][j + 1], v[i + 1][j], v[i][j]);
                this.triangleList.add(t);
            }
        }
        if (Math.PI == phi2) {
            for (int j = 0; j < k; ++j) {
                t = new Triangle(bottomPole, v[n][j], v[n][j + 1]);
                this.triangleList.add(t);
            }
        }
    }
}

