/*
 * Decompiled with CFR 0.152.
 */
import java.util.LinkedList;

public class Model {
    public Matrix modelMatrix;
    public LinkedList<Triangle> triangleList = new LinkedList();
    public boolean bilerp_flag;
    public boolean doBackFaceCulling;
    public boolean frontFacingIsCCW;
    public boolean doLighting;
    public boolean doSmoothLighting;
    public boolean doOpenglLighting;
    public int useVertexNumber;
    public boolean useHalfVector;
    public boolean doSmoothShading;
    public boolean doTransparancy;

    public Model() {
        this.modelMatrix = new Matrix(1.0);
        this.bilerp_flag = false;
        this.doBackFaceCulling = false;
        this.frontFacingIsCCW = true;
        this.doLighting = false;
        this.doSmoothLighting = true;
        this.doOpenglLighting = false;
        this.useVertexNumber = 0;
        this.useHalfVector = false;
        this.doSmoothShading = true;
        this.doTransparancy = false;
    }

    public Model(Model model) {
        this.modelMatrix = model.modelMatrix;
        this.bilerp_flag = model.bilerp_flag;
        this.frontFacingIsCCW = model.frontFacingIsCCW;
        this.doBackFaceCulling = model.doBackFaceCulling;
        this.doLighting = model.doLighting;
        this.doSmoothLighting = model.doSmoothLighting;
        this.doOpenglLighting = model.doOpenglLighting;
        this.useVertexNumber = model.useVertexNumber;
        this.useHalfVector = model.useHalfVector;
        this.doSmoothShading = model.doSmoothShading;
        this.doTransparancy = model.doTransparancy;
    }

    public void addTriangle(Triangle t) {
        this.triangleList.add(t);
    }

    public void model2Identity() {
        this.modelMatrix = new Matrix(1.0);
    }

    public void modelMult(Matrix m) {
        this.modelMatrix = this.modelMatrix.times(m);
    }

    public void modelRotate(double theta, double x, double y, double z) {
        this.modelMatrix = this.modelMatrix.times(new Matrix(theta, x, y, z));
    }

    public void modelScale(double x, double y, double z) {
        this.modelMatrix = this.modelMatrix.times(new Matrix(x, y, z));
    }

    public void modelTranslate(double x, double y, double z) {
        this.modelMatrix = this.modelMatrix.times(new Matrix(new Vector(x, y, z)));
    }

    public String toString() {
        String result = "";
        result = result + "This Model has " + this.triangleList.size() + " triangles\n";
        result = result + "doBackFaceCulling = " + this.doBackFaceCulling + "\n";
        result = result + "frontFacingIsCCW = " + this.frontFacingIsCCW + "\n";
        result = result + "doLighting = " + this.doLighting + "\n";
        result = result + "doSmoothLighting = " + this.doSmoothLighting + "\n";
        result = result + "doOpenglLighting = " + this.doOpenglLighting + "\n";
        result = result + "useVertexNumber = " + this.useVertexNumber + "\n";
        result = result + "useHalfVector = " + this.useHalfVector + "\n";
        result = result + "doSmoothShading = " + this.doSmoothShading + "\n";
        result = result + "doTransparancy = " + this.doTransparancy + "\n";
        return result;
    }

    public String printVertices() {
        String result = "";
        String printString = System.getenv("PrintLevel");
        if (printString != null) {
            int vertexFields = Integer.parseInt(printString);
            result = result + this.printVertices(vertexFields);
        }
        return result;
    }

    public String printVertices(int vertexFields) {
        String result = this.toString();
        for (Triangle t : this.triangleList) {
            result = result + t.toString(vertexFields);
        }
        return result;
    }

    public String printMatrices() {
        String result = "";
        String matrixString = System.getenv("MatrixFields");
        if (matrixString != null) {
            int matrixFields = Integer.parseInt(matrixString);
            result = result + this.printMatrices(matrixFields);
        }
        return result;
    }

    public String printMatrices(int matrixFields) {
        String result = "";
        if ((matrixFields & 4) == 4) {
            result = result + this.modelMatrix.toString();
        }
        return result;
    }
}

