/*
 * Decompiled with CFR 0.152.
 */
import java.util.LinkedList;

public class Scene {
    public LinkedList<Model> modelList = new LinkedList();
    public Matrix projMatrix;
    public Matrix viewMatrix;
    public Light light;

    public Scene() {
        this.projMatrix = new Matrix(1.0);
        this.viewMatrix = new Matrix(1.0);
        this.light = null;
    }

    public Scene(Scene scene) {
        this.projMatrix = scene.projMatrix;
        this.viewMatrix = scene.viewMatrix;
        this.light = scene.light;
    }

    public void addModel(Model model) {
        this.modelList.add(model);
    }

    public void proj2Identity() {
        this.projMatrix = new Matrix(1.0);
    }

    public void projMult(Matrix m) {
        this.projMatrix = this.projMatrix.times(m);
    }

    public void projPerspective(double fovy, double aspect, double zNear, double zFar) {
        double f = 1.0 / Math.tan(Math.PI / 180 * fovy / 2.0);
        this.projMatrix = this.projMatrix.times(new Matrix(new Vector(f / aspect, 0.0, 0.0, 0.0), new Vector(0.0, f, 0.0, 0.0), new Vector(0.0, 0.0, (zFar + zNear) / (zNear - zFar), -1.0), new Vector(0.0, 0.0, 2.0 * zFar * zNear / (zNear - zFar), 0.0)));
    }

    public void projFrustum(double left, double right, double bottom, double top, double near, double far) {
        double A = (right + left) / (right - left);
        double B = (top + bottom) / (top - bottom);
        double C = (far + near) / (far - near);
        double D = 2.0 * far * near / (far - near);
        this.projMatrix = this.projMatrix.times(new Matrix(new Vector(2.0 * near / (right - left), 0.0, 0.0, 0.0), new Vector(0.0, 2.0 * near / (top - bottom), 0.0, 0.0), new Vector(A, B, C, -1.0), new Vector(0.0, 0.0, D, 0.0)));
    }

    public void projOrtho(double left, double right, double bottom, double top, double near, double far) {
        double tx = -(right + left) / (right - left);
        double ty = -(top + bottom) / (top - bottom);
        double tz = -(far + near) / (far - near);
        this.projMatrix = this.projMatrix.times(new Matrix(new Vector(2.0 / (right - left), 0.0, 0.0, 0.0), new Vector(0.0, 2.0 / (top - bottom), 0.0, 0.0), new Vector(0.0, 0.0, -2.0 / (far - near), 0.0), new Vector(tx, ty, tz, 1.0)));
    }

    public void view2Identity() {
        this.viewMatrix = new Matrix(1.0);
    }

    public void viewLookAt(double eyex, double eyey, double eyez, double centerx, double centery, double centerz, double upx, double upy, double upz) {
        Vector F = new Vector(centerx - eyex, centery - eyey, centerz - eyez);
        Vector UP = new Vector(upx, upy, upz);
        Vector f = F.normalize();
        Vector up = UP.normalize();
        Vector s = f.crossProduct(up);
        Vector u = s.crossProduct(f);
        this.viewMatrix = this.viewMatrix.times(new Matrix(new Vector(s.x, u.x, -f.x, 0.0), new Vector(s.y, u.y, -f.y, 0.0), new Vector(s.z, u.z, -f.z, 0.0), new Vector(0.0, 0.0, 0.0, 1.0)));
        this.viewMatrix = this.viewMatrix.times(new Matrix(new Vector(-eyex, -eyey, -eyez)));
    }

    public void viewRotate(double theta, double x, double y, double z) {
        this.viewMatrix = this.viewMatrix.times(new Matrix(theta, x, y, z));
    }

    public void viewTranslate(double x, double y, double z) {
        this.viewMatrix = this.viewMatrix.times(new Matrix(new Vector(x, y, z)));
    }

    public String toString() {
        String result = "";
        result = result + "This Scene has " + this.modelList.size() + " models\n";
        result = result + "light = " + this.light + "\n";
        int i = 0;
        for (Model m : this.modelList) {
            result = result + "Model " + i++ + "\n";
            result = result + m.toString();
        }
        return result;
    }

    public String printMatrices() {
        String result = "";
        String matrixString = System.getenv("MatrixFields");
        if (matrixString != null) {
            int matrixFields = Integer.parseInt(matrixString);
            result = result + this.printMatrices(matrixFields);
        }
        return result;
    }

    public String printMatrices(int matrixFields) {
        String result = "";
        if ((matrixFields & 1) == 1) {
            result = result + this.viewMatrix.toString();
        }
        if ((matrixFields & 2) == 2) {
            result = result + this.projMatrix.toString();
        }
        return result;
    }
}

