/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.WritableRaster;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JFrame;

public class Texture {
    public int width;
    public int height;
    public byte[] data;

    public Texture(int width, int height, byte[] data) {
        this.width = width;
        this.height = height;
        this.data = data;
    }

    public Texture(String filename) {
        try {
            DataInputStream dis = new DataInputStream(new BufferedInputStream(new FileInputStream(filename)));
            if (Integer.toHexString(dis.readInt()).substring(0, 4).equals("5036")) {
                this.readPPMTexture(filename);
            } else {
                this.readTexture(filename);
            }
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
            System.err.println("File not found.");
            System.exit(-1);
        }
    }

    public void readTexture(String filename) {
        BufferedImage img = null;
        try {
            img = ImageIO.read(new File(filename));
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
            System.err.println("Cannot read image file.");
            System.exit(-1);
        }
        this.width = img.getWidth();
        this.height = img.getHeight();
        WritableRaster raster = img.getRaster();
        DataBufferByte rast_data = (DataBufferByte)raster.getDataBuffer();
        this.data = rast_data.getData();
    }

    public void readPPMTexture(String filename) {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(filename);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace(System.err);
            System.err.printf("ERROR! Could not open texture %s\n", filename);
            System.exit(-1);
        }
        try {
            String magicNumber = "";
            char c = (char)fis.read();
            while (c != '\n') {
                magicNumber = magicNumber + c;
                c = (char)fis.read();
            }
            if (!magicNumber.trim().startsWith("P6")) {
                System.err.printf("ERROR! Improper PPM number in file %s\n", filename);
                System.exit(-1);
            }
            if ('#' == (c = (char)fis.read())) {
                while (c != '\n') {
                    c = (char)fis.read();
                }
                c = (char)fis.read();
            }
            String widthDim = "";
            while (c != ' ' && c != '\n') {
                widthDim = widthDim + c;
                c = (char)fis.read();
            }
            this.width = Integer.parseInt(widthDim.trim());
            String heightDim = "";
            c = (char)fis.read();
            while (c != '\n') {
                heightDim = heightDim + c;
                c = (char)fis.read();
            }
            this.height = Integer.parseInt(heightDim.trim());
            System.err.printf("Texture %s: width=%d, height=%d\n\n", filename, this.width, this.height);
            c = (char)fis.read();
            while (c != '\n') {
                c = (char)fis.read();
            }
            this.data = new byte[this.width * this.height * 3];
            for (int y = 0; y < this.height; ++y) {
                if (fis.read(this.data, (this.height - y - 1) * 3 * this.width, 3 * this.width) == 3 * this.width) continue;
                System.err.printf("ERROR! Could not load texture %s\n", filename);
                System.exit(-1);
            }
            fis.close();
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
            System.err.printf("ERROR! Could not read texture %s\n", filename);
            System.exit(-1);
        }
    }

    public static void main(String[] args) {
        Texture t4;
        Texture t1 = new Texture("../Clients/Resources/Yoda.ppm");
        Texture t2 = new Texture("../Clients/Resources/Yoda.png");
        Texture t3 = new Texture("../Clients/Resources/Yoda.jpg");
        Texture t = t4 = new Texture("../Clients/Resources/Yoda.gif");
        JFrame frame = new JFrame("Drawing 2D Shapes");
        frame.setDefaultCloseOperation(3);
        frame.setSize(t.width + 50, t.height + 100);
        frame.setVisible(true);
        Graphics gr = frame.getGraphics();
        Image image = frame.createImage(t.width + 50, t.height + 100);
        Graphics gOff = image.getGraphics();
        gOff.setColor(Color.black);
        gOff.fillRect(0, 0, t.width + 50, t.height + 100);
        for (int y = 0; y < t.height; ++y) {
            for (int x = 0; x < t.width; ++x) {
                int r = t.data[(y * t.width + x) * 3 + 0];
                int g = t.data[(y * t.width + x) * 3 + 1];
                int b = t.data[(y * t.width + x) * 3 + 2];
                if (r < 0) {
                    r = 256 + r;
                }
                if (g < 0) {
                    g = 256 + g;
                }
                if (b < 0) {
                    b = 256 + b;
                }
                gOff.setColor(new Color(r, g, b));
                gOff.drawLine(x + 25, y + 50, x + 25, y + 50);
            }
        }
        gr.drawImage(image, 0, 0, null);
    }
}

