/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.util.Random;

public class Vertex {
    public double x;
    public double y;
    public double z;
    public double w;
    public double r;
    public double g;
    public double b;
    public double a;
    public double s;
    public double t;
    public Vector n;

    public Vertex() {
        this(0.0, 0.0, 0.0, 1.0);
    }

    public Vertex(double x, double y, double z) {
        this(x, y, z, 1.0);
    }

    public Vertex(float[] v) {
        this(v[0], v[1], v[2], v[3]);
    }

    public Vertex(double x, double y, double z, double w) {
        this.set(x, y, z, w);
        this.setColor(0.0, 0.0, 0.0, 0.0);
        this.s = 0.0;
        this.t = 0.0;
        this.n = null;
    }

    public Vertex(Vertex v) {
        this.set(v.x, v.y, v.z, v.w);
        this.setColor(v.r, v.g, v.b, v.a);
        this.s = v.s;
        this.t = v.t;
        this.n = null;
        if (null != v.n) {
            this.n = new Vector(v.n);
        }
    }

    public Vector minus(Vertex v) {
        return new Vector(this.x - v.x, this.y - v.y, this.z - v.z, this.w - v.w);
    }

    public void set(double x, double y, double z) {
        this.set(x, y, z, 1.0);
    }

    public void set(double x, double y, double z, double w) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
    }

    public void setColor(double r, double g, double b, double a) {
        this.r = r;
        this.g = g;
        this.b = b;
        this.a = a;
        if (r < 0.0 || r > 1.0 || g < 0.0 || g > 1.0 || b < 0.0 || b > 1.0 || a < 0.0 || a > 1.0) {
            System.err.println("ERROR! Invalid double color for vertex");
            System.err.println(this.toString(3));
            System.exit(-1);
        }
    }

    public void setColor(double r, double g, double b) {
        this.setColor(r, g, b, 0.0);
    }

    public void setColor(Vertex v) {
        double r = v.r;
        double g = v.g;
        double b = v.b;
        this.setColor(r, g, b, 0.0);
    }

    public void setColorRandom() {
        Random generator = new Random();
        double r = generator.nextDouble();
        double g = generator.nextDouble();
        double b = generator.nextDouble();
        this.setColor(r, g, b, 0.0);
    }

    public void setColor(int r, int g, int b, int a) {
        this.r = (float)r / 255.0f;
        this.g = (float)g / 255.0f;
        this.b = (float)b / 255.0f;
        this.a = (float)a / 255.0f;
        if (r < 0 || r > 255 || g < 0 || g > 255 || b < 0 || b > 255 || a < 0 || a > 255) {
            System.err.println("ERROR! Invalid int color for vertex");
            System.err.println(this.toString(3));
            System.exit(-1);
        }
    }

    public void setColor(int r, int g, int b) {
        this.setColor(r, g, b, 0);
    }

    public void setColor(Color c) {
        this.setColor(c.getRed(), c.getGreen(), c.getBlue(), 0);
    }

    public Color getColor() {
        return new Color((float)this.r, (float)this.g, (float)this.b);
    }

    public void setCoords(double s, double t) {
        this.s = s;
        this.t = t;
    }

    public void setNormal(Vector n) {
        this.n = n;
    }

    public Vertex times(double scalar) {
        Vertex temp = new Vertex(scalar * this.x, scalar * this.y, scalar * this.z, scalar * this.w);
        temp.r = this.r;
        temp.g = this.g;
        temp.b = this.b;
        temp.a = this.a;
        temp.s = this.s;
        temp.t = this.t;
        temp.n = this.n;
        return temp;
    }

    public String toString() {
        int p = 5;
        int t = p + 4;
        String format = "(x,y,z,w) = (% " + t + "." + p + "f  % " + t + "." + p + "f  % " + t + "." + p + "f  % " + t + "." + p + "f)\n";
        return String.format(format, this.x, this.y, this.z, this.w);
    }

    public String toString(int vertexFields) {
        String result = "";
        int p = 5;
        int t = p + 4;
        if (1 == (vertexFields & 1)) {
            String format = "(x,y,z,w) = (% " + t + "." + p + "f  % " + t + "." + p + "f  % " + t + "." + p + "f  % " + t + "." + p + "f)\n";
            result = result + String.format(format, this.x, this.y, this.z, this.w);
        }
        if (2 == (vertexFields & 2)) {
            result = result + String.format("<r,g,b,a> = <% .5f  % .5f  % .5f  % .5f>\n", this.r, this.g, this.b, this.a);
        }
        if (4 == (vertexFields & 4)) {
            result = result + String.format("    {s,t} = {% .5f  % .5f}\n", this.s, t);
        }
        if (8 == (vertexFields & 8)) {
            result = result + String.format("n -> \n", new Object[0]);
            result = null == this.n ? result + "null" : result + this.n.toString();
        }
        return result;
    }
}

