/**
   Shade vertices according to their location
   in the current coordinate system.

   This class is a "pipeline stage" because it
   implements the PipelineStage interface, which
   consistes of a single method, processModel().
*/
import java.awt.Color;

public class ColorShader implements PipelineStage
{
   private Color c1;
   private Color c2;
   private double spacing;

   public ColorShader(Color c1, Color c2, double spacing)
   {
      this.c1 = c1;
      this.c2 = c2;
      this.spacing = spacing;
   }


   /**
      Stripe the model with the colors c1 and c2 in the x-direction.
      This can be done in either model coordinates, world-coordinates,
      or view-coordinates.
   */
   public Model processModel(Model model)
   {
      for (Triangle t : model.triangleList)
      {
         // Get the x-coordinate of each vertex in the triangle.
         double x0 = t.v[0].x;
         double x1 = t.v[1].x;
         double x2 = t.v[2].x;

         // Color the first vertex.
         if ( 0 == (Math.floor(x0 / spacing) % 2) )
            t.v[0].setColor( c1 );
         else
            t.v[0].setColor( c2 );

         // Color the second vertex.
         if ( 0 == (Math.floor(x1 / spacing) % 2) )
            t.v[1].setColor( c1 );
         else
            t.v[1].setColor( c2 );

         // Color the third vertex.
         if ( 0 == (Math.floor(x2 / spacing) % 2) )
            t.v[2].setColor( c1 );
         else
            t.v[2].setColor( c2 );
      }
      return model;
   }
}