/*
   This program is a client of the ColorShader
   pipeline stage. This program puts the ColorShader
   pipeline stage into a rendering pipeline at three
   different places and shows the effects of the shader.
*/
import java.io.File;
import java.awt.Color;

public class ColorShaderClient
{
   public static void main(String[] args)
   {
      // Create several Model objects.
      Model m1 = new ObjSimpleModel(new File("resources/horse.obj"));
      m1.doBackFaceCulling = true;
      m1.modelTranslate(-2, 0, 0);
      m1.modelScale(0.5, 0.5, 0.5);

      Model m2 = new SphereModel(30, 30, 1);
      m2.doBackFaceCulling = true;
      m2.modelTranslate(3, 0, 0);
      m2.modelScale(2, 2, 2);

      Model m3 = new ObjSimpleModel(new File("resources/apple.obj"), true);
      m3.doBackFaceCulling = true;
      m3.modelTranslate(0, 3, 0);
      m3.modelScale(2, 2, 2);

      // Create the Scene object that we shall render
      Scene scene = new Scene();

      // Add the models to the Scene.
      scene.modelList.add(m1);
      scene.modelList.add(m2);
      scene.modelList.add(m3);

      // Give the Scene a view matrix.
      scene.view2Identity();

      // Give the scene a projection matrix.
      scene.proj2Identity();

      // Set up the scene's view frustum.
      double fov    = 60.0;
      double aspect = 1.0;
      double near   = 1.0;
      double far    = 20.0;
      scene.projPerspective(fov, aspect, near, far);

      // Set up the scene's "camera".
      double eyex=0,    eyey=0,    eyez=10;
      double centerx=0, centery=0, centerz=0;
      double upx=0,     upy=1,     upz=0;
      scene.viewLookAt(eyex,    eyey,    eyez,
                       centerx, centery, centerz,
                       upx,     upy,     upz);

      // Create a framebuffer to render our scene into.
      int vp_width  = 1200;
      int vp_height =  400;
      FrameBuffer fb = new FrameBuffer(vp_width, vp_height);
      // Give the framebuffer a nice background color.
      fb.clearFB(java.awt.Color.darkGray);



      // Create an instance of the shader pipeline stage.
      PipelineStage shader = new ColorShader(Color.red, Color.blue, 0.5);
      // Create a rendering pipeline,
      SceneRender renderer1 = new SceneRender(scene, fb);  // default pipeline
      renderer1.removePipelineStage(12); // remove texture stage
      renderer1.removePipelineStage(5);  // remove both the lighting stages
      renderer1.removePipelineStage(4);
      // Add the shader stage to this pipeline before model2world
      renderer1.insertPipelineStage(1, shader);

      // Create a second rendering pipeline,
      SceneRender renderer2 = new SceneRender(scene, fb);  // default pipeline
      renderer2.removePipelineStage(12); // remove texture stage
      renderer2.removePipelineStage(5);  // remove both the lighting stages
      renderer2.removePipelineStage(4);
      // Add the shader stage to this pipeline after model2world (and before world2view)
      renderer2.insertPipelineStage(2, shader);

      // Create a third rendering pipeline,
      SceneRender renderer3 = new SceneRender(scene, fb);  // default pipeline
      renderer3.removePipelineStage(12); // remove texture stage
      renderer3.removePipelineStage(5);  // remove both the lighting stages
      renderer3.removePipelineStage(4);
      // Add the shader stage to this pipeline after world2view
      renderer3.insertPipelineStage(3, shader);

      // Check the order of the pipeline stages            .
      System.err.println( renderer1 );
      System.err.println( renderer2 );
      System.err.println( renderer3 );


      // Set a viewport within the frambuffer.
      fb.setViewport(0, 0, 400, 400); //upper-left-hand-corner, width, height
      // Give the viewport a nice background color.
      fb.clearVP(java.awt.Color.darkGray.brighter().brighter());
      // Render our scene into the current viewport using the first renderer.
      renderer1.renderScene();

      // Set a viewport within the frambuffer.
      fb.setViewport(400, 0, 400, 400); //upper-left-hand-corner, width, height
      // Give the viewport a nice background color.
      fb.clearVP(java.awt.Color.darkGray.brighter().brighter());
      // Render our scene into the current viewport using the second renderer.
      renderer2.renderScene();

      // Set a viewport within the frambuffer.
      fb.setViewport(800, 0, 400, 400); //upper-left-hand-corner, width, height
      // Give the viewport a nice background color.
      fb.clearVP(java.awt.Color.darkGray.brighter().brighter());
      // Render our scene into the current viewport using the third renderer.
      renderer3.renderScene();

      // Save the resulting image in a file.
      fb.dumpFB2File( String.format("PPM_ColorShaderClient_Frame%02d.ppm", 0) );

      // Spin the scene 360 degrees.
      for (int i = 1; i <= 36; i++)
      {
         // Rotate the new scene by 10 degrees.
         scene.viewRotate(10, 0, 1, 0);
         // Render again.
         // Set a viewport within the frambuffer.
         fb.setViewport(0, 0, 400, 400); //upper-left-hand-corner, width, height
         // Give the viewport a nice background color.
         fb.clearVP(java.awt.Color.darkGray.brighter().brighter());
         // Render our scene into the current viewport using the first renderer.
         renderer1.renderScene();

         // Set a viewport within the frambuffer.
         fb.setViewport(400, 0, 400, 400); //upper-left-hand-corner, width, height
         // Give the viewport a nice background color.
         fb.clearVP(java.awt.Color.darkGray.brighter().brighter());
         // Render our scene into the current viewport using the second renderer.
         renderer2.renderScene();

         // Set a viewport within the frambuffer.
         fb.setViewport(800, 0, 400, 400); //upper-left-hand-corner, width, height
         // Give the viewport a nice background color.
         fb.clearVP(java.awt.Color.darkGray.brighter().brighter());
         // Render our scene into the current viewport using the third renderer.
         renderer3.renderScene();

         // Save the resulting image in a file.
         fb.dumpFB2File(String.format("PPM_ColorShaderClient_Frame%02d.ppm", i));
      }
   }
}