/**
   Randomly delete triangles from each model.

   This class is a "pipeline stage" because it
   implements the PipelineStage interface, which
   consistes of a single method, processModel().
*/
import java.util.Random;

public class DropShader implements PipelineStage
{
   private double probability;
   private Random generator;

   public DropShader(double probability)
   {
      this.probability = probability;

      generator = new Random();
   }


   /**
      Randomly drop triangles from this model's list of triangles.
   */
   public Model processModel(Model model)
   {
      Model newModel = new Model(model); // copy everything but the triangles

      for (Triangle t : model.triangleList)
      {
         double r = generator.nextDouble();
         if (r >= probability)
            newModel.addTriangle(t);
      }

      return newModel;
   }
}