/*
   This program is a client of the DropShader
   pipeline stage.
*/
import java.io.File;
import java.awt.Color;

public class DropShaderClient
{
   public static void main(String[] args)
   {
      // Create several Model objects.
      Model m1 = new ObjSimpleModel(new File("resources/horse.obj"));
      for (Triangle t : m1.triangleList)
      {  // give every vertex a random color
         t.v[0].setColorRandom();
         t.v[1].setColorRandom();
         t.v[2].setColorRandom();
      }
      m1.doBackFaceCulling = true;
      m1.modelScale(0.5, 0.5, 0.5);
      m1.modelTranslate(-4, 0, -4);
      m1.modelRotate(90, 0,1,0);

      Model m2 = new ObjSimpleModel(new File("resources/small_rhombicosidodecahedron.obj"), true);
      m2.doBackFaceCulling = true;
      m2.modelScale(0.3, 0.3, 0.3);
      m2.modelTranslate(5, 0, 5);

      Model m3 = new ObjSimpleModel(new File("resources/great_rhombicosidodecahedron.obj"), true);
      m3.doBackFaceCulling = true;
      m3.modelScale(0.2, 0.2, 0.2);
      m3.modelTranslate(0, 0, 0);

      Model m4 = new ObjSimpleModel(new File("resources/apple.obj"), true);
      m4.doBackFaceCulling = true;
      m4.modelTranslate(0, 2, 0);
      m4.modelScale(2, 2, 2);
      m4.modelRotate(90, 0,0,1);

      // Create the Scene object that we shall render
      Scene scene = new Scene();

      // Add the models to the Scene.
      scene.modelList.add(m1);
      scene.modelList.add(m2);
      scene.modelList.add(m3);
      scene.modelList.add(m4);

      // Give the Scene a view matrix.
      scene.view2Identity();

      // Give the scene a projection matrix.
      scene.proj2Identity();

      // Set up the scene's view frustum.
      double fov    = 45.0;
      double aspect = 1.0;
      double near   = 1.0;
      double far    = 20.0;
      scene.projPerspective(fov, aspect, near, far);

      // Set up the scene's "camera".
      double eyex=0,    eyey=0,    eyez=10;
      double centerx=0, centery=0, centerz=0;
      double upx=0,     upy=1,     upz=0;
      scene.viewLookAt(eyex,    eyey,    eyez,
                       centerx, centery, centerz,
                       upx,     upy,     upz);

      // Create a framebuffer to render our scene into.
      int vp_width  = 512;
      int vp_height = 512;
      FrameBuffer fb = new FrameBuffer(vp_width, vp_height);
      // Give the framebuffer a nice background color.
      fb.clearFB(java.awt.Color.darkGray);



      // Create an instance of the shader pipeline stage.
      PipelineStage shader = new DropShader(0.33);
      // Create a rendering pipeline.
      SceneRender renderer = new SceneRender(scene, fb);  // default pipeline
      renderer.removePipelineStage(12); // remove texture stage
      renderer.removePipelineStage(5);  // remove both the lighting stages
      renderer.removePipelineStage(4);
      // Add the shader stage to this pipeline after the backface culling stage
      renderer.insertPipelineStage(4, shader);

      // Check the order of the pipeline stages.
      System.err.println( renderer );

      // Render our scene.
      renderer.renderScene();
      // Save the resulting image in a file.
      fb.dumpFB2File( String.format("PPM_DropShaderClient_Frame%02d.ppm", 0) );

      for (int i = 1; i <= 36; i++)
      {
         // Render again.
         fb.clearFB(java.awt.Color.darkGray);
         renderer.renderScene();
         fb.dumpFB2File(String.format("PPM_DropShaderClient_Frame%02d.ppm", i));
      }
   }
}