/*

*/

package TimeZoneWebService;

import java.text.DateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.Scanner;

/**
   This program implements a time zone service.

   This program expects the name of a city as a
   String in System.in. The city name is looked
   up in Java's built-in list of time zones. If
   the city is found in the list, then a String
   holding that city's current time is sent to
   the service client.

   See
   https://docs.oracle.com/en/java/javase//21/docs/api/java.base/java/util/TimeZone.html
*/
public class TimeZoneService
{
   private static final DateFormat timeFormatter = DateFormat.getTimeInstance();
   private static final String[] timeZoneIds = TimeZone.getAvailableIDs();

   /**

   */
   public static void main(String[] args)
   {
      // Get the city name from System.in.
      String cityName = null;
      try (final Scanner in = new Scanner(System.in))
      {
         cityName = in.nextLine().trim();
      }

      // Look up the city name in Java's built-in list of time zones.
      String timeZoneId = null;
      TimeZone timeZone = null;
      for (int i = 0; i < timeZoneIds.length; ++i)
      {
         timeZoneId = timeZoneIds[i];
         final int timeZoneCityIndex = timeZoneId.lastIndexOf('/') + 1;
         final String timeZoneCity = timeZoneId.substring(timeZoneCityIndex);
         if (timeZoneCity.replace('_', ' ').equals(cityName))
         {
            // Found.
            timeZone = TimeZone.getTimeZone(timeZoneId);
            break;
         }
      }

      final String timeString;
      if (timeZone != null) // if the city name was found
      {
         timeFormatter.setTimeZone(timeZone);
         final Date time = new Date();
         timeString = timeFormatter.format(time);
      }
      else
      {
         timeString = "null";
         timeZoneId = "null";
      }

      // Log the result.
      System.err.println("=====> INFO: TimeZoneService: city = " + cityName
                                           + ", time zone id = " + timeZoneId
                                                   + ", time = " + timeString);

      // Send the result.
      System.out.print(timeString + "\n");
      System.out.flush();
      System.out.close();
   }
}
