/*
   This program reads 16 bytes of data from
   standard input.


   Run this program on the command-line and
   have it read the data file created with
   CreateData.java.

   > java  ReadDataAsByte  <  data

   Alternatively, you can pipe the output from
   CreateData directly into this program.

   > java CreateData | java ReadDataAsByte
*/

import java.io.*;

public class ReadDataAsByte
{
   public static void main(String[] args)
   {
      DataInputStream in = new DataInputStream(System.in);

      final byte[] b = new byte[16];

      try
      {
         for (int i = 0; i < b.length; ++i)
         {
            b[i] = in.readByte();
         }

         for (int i = 0; i < b.length; ++i)
         {
            System.out.println(b[i]);
          //System.out.printf("%02X\n", b[i]);
         }
      }
      catch (IOException e)
      {
         System.out.print( e );
      }
   }
}

// https://docs.oracle.com/en/java/javase/21/docs/api/java.base/java/io/DataInputStream.html#readByte()
// https://docs.oracle.com/en/java/javase/21/docs/api/java.base/java/io/DataInput.html#readByte()
