/*
   This program reads 16 bytes of data from
   standard input and interprets those bytes
   as eight chars (each char is two bytes).

   Run this program on the command-line and
   have it read the data file created with
   CreateData.java.

   > java  ReadDataAsChar  <  data

   Alternatively, you can pipe the output from
   CreateData directly into this program.

   > java CreateData | java ReadDataAsChar
*/

import java.io.*;

public class ReadDataAsChar
{
   public static void main(String[] args)
   {
      DataInputStream in = new DataInputStream(System.in);

      try
      {
         final char c1 = in.readChar();
         final char c2 = in.readChar();
         final char c3 = in.readChar();
         final char c4 = in.readChar();
         final char c5 = in.readChar();
         final char c6 = in.readChar();
         final char c7 = in.readChar();
         final char c8 = in.readChar();
       //final char c9 = in.readChar();

         System.out.println(c1);
         System.out.println(c2);
         System.out.println(c3);
         System.out.println(c4);
         System.out.println(c5);
         System.out.println(c6);
         System.out.println(c7);
         System.out.println(c8);

         // Do the reverse of what we just did.
         //DataOutputStream out = new DataOutputStream(System.out);
         //out.writeInt(c1);
         //out.writeInt(c2);
         //out.writeInt(c3);
         //out.writeInt(c4);
         //out.writeInt(c5);
         //out.writeInt(c6);
         //out.writeInt(c7);
         //out.writeInt(c8);
         //out.flush();
      }
      catch (IOException e)
      {
         System.out.print( e );
      }
   }
}

// https://docs.oracle.com/en/java/javase/21/docs/api/java.base/java/io/DataInputStream.html#readChar()
// https://docs.oracle.com/en/java/javase/21/docs/api/java.base/java/io/DataInput.html#readChar()
