/*
   This program reads 16 bytes of data from
   standard input and interprets those bytes
   as two doubles (each double is eight bytes).

   Run this program on the command-line and
   have it read the data file created with
   CreateData.java.

   > java  ReadDataAsDouble  <  data

   Alternatively, you can pipe the output from
   CreateData directly into this program.

   > java CreateData | java ReadDataAsDouble
*/

import java.io.*;

public class ReadDataAsDouble
{
   public static void main(String[] args)
   {
      DataInputStream in = new DataInputStream(System.in);

      try
      {
         final double n1 = in.readDouble();
         final double n2 = in.readDouble();

         System.out.println(n1);
         System.out.println(n2);

         // Do the reverse of what we just did.
         //DataOutputStream out = new DataOutputStream(System.out);
         //out.writeDouble(n1);
         //out.writeDouble(n2);
         //out.flush();
      }
      catch (IOException e)
      {
         System.out.print( e );
      }
   }
}

// https://docs.oracle.com/en/java/javase/21/docs/api/java.base/java/io/DataInputStream.html#readDouble()
// https://docs.oracle.com/en/java/javase/21/docs/api/java.base/java/io/DataInput.html#readDouble()
