/*
   This program reads 16 bytes of data from
   standard input and interprets those bytes
   as four ints (each int is four bytes).

   Run this program on the command-line and
   have it read the data file created with
   CreateData.java.

   > java  ReadDataAsInt  <  data

   Alternatively, you can pipe the output from
   CreateData directly into this program.

   > java CreateData | java ReadDataAsInt
*/

import java.io.*;

public class ReadDataAsInt
{
   public static void main(String[] args)
   {
      DataInputStream in = new DataInputStream(System.in);

      try
      {
         final int n1 = in.readInt();
         final int n2 = in.readInt();
         final int n3 = in.readInt();
         final int n4 = in.readInt();

         System.out.println(n1);
         System.out.println(n2);
         System.out.println(n3);
         System.out.println(n4);

         // Do the reverse of what we just did.
         //DataOutputStream out = new DataOutputStream(System.out);
         //out.writeInt(n1);
         //out.writeInt(n2);
         //out.writeInt(n3);
         //out.writeInt(n4);
         //out.flush();
      }
      catch (IOException e)
      {
         System.out.print( e );
      }
   }
}

// https://docs.oracle.com/en/java/javase/21/docs/api/java.base/java/io/DataInputStream.html#readInt()
// https://docs.oracle.com/en/java/javase/21/docs/api/java.base/java/io/DataInput.html#readInt()
